<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-03 16:02:50
 */
namespace Mainto\Bridge\Invokes\ProjectPaperless\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 */
class Staff {
    private static string $serviceName = "ProjectPaperless";

    private static string $className = "User\\Staff";

    /**
     * 获取伙伴信息
     * @return  array
    */
    public static function getInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo();
    }
    /**
     * 获取钉钉头像
     * @return  array
    */
    public static function getDingDingHead (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDingDingHead(["staffId" => $staffId]);
    }
    /**
     * 选择进入的身份类型[done]
     * @return  mixed
    */
    public static function chooseType (int $storeId, int $staffId, string $staffType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->chooseType(["storeId" => $storeId, "staffId" => $staffId, "staffType" => $staffType]);
    }
    /**
     * 开始工作
     * @return  bool
    */
    public static function beginWork () {
        return RpcClass::getClass(self::$serviceName, self::$className)->beginWork();
    }
    /**
     * 结束工作
     * @return  bool
    */
    public static function endWork () {
        return RpcClass::getClass(self::$serviceName, self::$className)->endWork();
    }
    /**
     * 挂起
     * @return  bool
    */
    public static function hang () {
        return RpcClass::getClass(self::$serviceName, self::$className)->hang();
    }
    /**
     * 取消挂起
     * @return  bool
    */
    public static function cancelHang () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelHang();
    }
    /**
     * 获取今日工作明细
     * @return  mixed
    */
    public static function getTodayWorkDetails () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTodayWorkDetails();
    }
    /**
     * 获取伙伴订单列表
     * @return  mixed
    */
    public static function getStaffOrders () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffOrders();
    }
    /**
     * 获取伙伴的状态
     * @return  mixed
    */
    public static function getStaffStatus () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffStatus();
    }
    /**
     * 获取可协作的伙伴列表
     * @return  array
    */
    public static function getAssistants () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAssistants();
    }
    /**
     * 通过staffIds获取伙伴名字列表
     * @return  array
    */
    public static function getNamesByStaffIds (array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNamesByStaffIds(["staffIds" => $staffIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}