<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-04-03 16:02:50
 */
namespace Mainto\Bridge\Invokes\ProjectPaperless\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Process
 */
class Process {
    private static string $serviceName = "ProjectPaperless";

    private static string $className = "User\\Process";

    /**
     * 主化妆师继续化妆
     * @return  mixed
    */
    public static function continueToMakeUp (int $processId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->continueToMakeUp(["processId" => $processId]);
    }
    /**
     * 获取多产品协作信息
     * @return  array
    */
    public static function getMakeUpAssistants (int $processId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMakeUpAssistants(["processId" => $processId]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\DTO\ProcessDresserDTO[]"
        );
    }
    /**
     * 完成化妆
     * @return  bool
    */
    public static function completeMakeUp (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\Cmd\CompleteProcessCmd $completeProcessCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->completeMakeUp($completeProcessCmd);
    }
    /**
     * 完成摄影
     * @return  mixed
    */
    public static function completePhotography (int $processId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->completePhotography(["processId" => $processId]);
    }
    /**
     * 完成并挂起
     * @return  mixed
    */
    public static function completeAndHang (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\Cmd\CompleteProcessCmd $completeProcessCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->completeAndHang($completeProcessCmd);
    }
    /**
     * 完成摄影去选片
     * @return  mixed
    */
    public static function goSelectPhoto (int $processId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->goSelectPhoto(["processId" => $processId]);
    }
    /**
     * 指派协作化妆师
     * @return  bool
    */
    public static function assignAssistance (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\Cmd\AssignAssistanceCmd $assignAssistanceCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->assignAssistance($assignAssistanceCmd);
    }
    /**
     * 再来一单
     * @return  bool
    */
    public static function orderAgain (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderAgain(["orderId" => $orderId]);
    }
    /**
     * 接新订单
     * @return  mixed
    */
    public static function takeOrder () {
        return RpcClass::getClass(self::$serviceName, self::$className)->takeOrder();
    }
    /**
     * 更新流程备注信息
     * @return  mixed
    */
    public static function saveNote (int $processId, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveNote(["processId" => $processId, "note" => $note]);
    }
    /**
     * 获取云端产品信息
     * @return  array
    */
    public static function getCloudProductInfo (int $processId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudProductInfo(["processId" => $processId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}