<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-10-31 19:22:17
 */
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 */
class Staff {
    private static string $serviceName = "ProjectPaperless";

    private static string $className = "Manage\\Staff";

    /**
     * 取消挂起
     *
     */
    public static function cancelHang (int $staffId, string $staffType): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelHang(["staffId" => $staffId, "staffType" => $staffType, ]);
    }
    /**
     * 获取伙伴的状态
     *
     */
    public static function getStaffStatus (int $staffId, string $staffType): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffStatus(["staffId" => $staffId, "staffType" => $staffType, ]);
    }
    /**
     * 通过staffIds获取伙伴名字列表
     *
     */
    public static function getNamesByStaffIds (array $staffIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNamesByStaffIds(["staffIds" => $staffIds, ]);
    }
    /**
     * 开始工作
     *
     */
    public static function beginWork (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->beginWork();
    }
    /**
     * 结束工作
     *
     */
    public static function endWork (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->endWork();
    }
    /**
     * 门店工作信息
     *
     */
    public static function getProcessingTimes (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProcessingTimes();
    }
    /**
     * 根据伙伴id获取伙伴信息
     *
     */
    public static function getStaffInfoById (int $staffId): \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Staff\GetStaffInfoByIdDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStaffInfoById(["staffId" => $staffId, ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Staff\GetStaffInfoByIdDTO"
        );
    }
    /**
     * 获取员工通关产品数据
     *
     */
    public static function showStaffProducts (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->showStaffProducts(["staffId" => $staffId, ]);
    }
    /**
     * 获取产品数
     *
     */
    public static function getProductCatAll (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCatAll();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}