<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-10-31 19:22:17
 */
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "ProjectPaperless";

    private static string $className = "Manage\\Product";

    /**
     * 获取产品信息
     *
     */
    public static function cloudProductInfo (\Mainto\Bridge\Structs\ProjectPaperless\Product\Dto\ProductInfoDto $productInfoDto): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->cloudProductInfo($productInfoDto),
            "\Mainto\Bridge\Structs\ProjectPaperless\Product\Dto\ProductInfoResDto[]"
        );
    }
    /**
     * 获取云端产品的修图风格
     *
     */
    public static function productRetouchStyle (int $productId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productRetouchStyle(["productId" => $productId, ]);
    }
    /**
     * 评价修图师风格
     *
     */
    public static function evaluateRetoucher (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\EvaluateRetoucherDto $evaluateRetoucherDto): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->evaluateRetoucher($evaluateRetoucherDto);
    }
    /**
     * 获取产品的技术要点
     *
     */
    public static function cloudTechnologyDetail (int $productId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->cloudTechnologyDetail(["productId" => $productId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}