<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-10-28 10:58:56
 */
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PictureOnline
 */
class PictureOnline {
    private static string $serviceName = "ProjectPaperless";

    private static string $className = "Manage\\PictureOnline";

    /**
     * 在线看片设置打印
     *
     */
    public static function setPrint (string $recordNo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPrint(["recordNo" => $recordNo, ]);
    }
    /**
     * 在线看片详情
     *
     */
    public static function detail (string $orderNum): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["orderNum" => $orderNum, ]);
    }
    /**
     * 根据看片单ids获取打印尺寸
     *
     */
    public static function getPhotoSizeByIds (array $ids): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoSizeByIds(["ids" => $ids, ]);
    }
    /**
     * 修改取片方式
     *
     */
    public static function changeTakePhotoType (string $recordNo, string $takeType, \Mainto\Bridge\Structs\ProjectPaperless\Manage\PictureOnline\ChangeTakePhotoTypeParamsPostInfo $postInfo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeTakePhotoType(["recordNo" => $recordNo, "takeType" => $takeType, "postInfo" => $postInfo, ]);
    }
    /**
     * 标记发件
     *
     */
    public static function addPostNum (string $recordNo, string $postNum): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->addPostNum(["recordNo" => $recordNo, "postNum" => $postNum, ]);
    }
    /**
     * 订单是否符合在线看片
     *
     */
    public static function checkConformOnlineOrder (string $orderNo, int $storeId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkConformOnlineOrder(["orderNo" => $orderNo, "storeId" => $storeId, ]);
    }
    /**
     * 批量获取订单是否符合在线看片
     *
     */
    public static function batchCheckConformOnlineOrder (array $orderInfo): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCheckConformOnlineOrder(["orderInfo" => $orderInfo, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}