<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-10-28 10:58:56
 */
namespace Mainto\Bridge\Invokes\ProjectPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PaperlessOrder
 */
class PaperlessOrder {
    private static string $serviceName = "ProjectPaperless";

    private static string $className = "Api\\PaperlessOrder";

    /**
     * 无纸化订单信息
     *
     */
    public static function getPaperlessOrder (int $orderId, bool $withTrashed): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaperlessOrder(["orderId" => $orderId, "withTrashed" => $withTrashed, ]);
    }
    /**
     * 批量获取无纸化订单信息
     *
     */
    public static function getPaperlessOrderByOrderIds (array $orderIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaperlessOrderByOrderIds(["orderIds" => $orderIds, ]);
    }
    /**
     * 获取某个进行中阶段的数据
     *
     */
    public static function getActiveStageRecord (string $createStartAt, string $createEndAt, string $stage, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActiveStageRecord(["createStartAt" => $createStartAt, "createEndAt" => $createEndAt, "stage" => $stage, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 通过时间筛选待看片订单
     *
     */
    public static function getWaitLookingOrders (string $startAt, string $endAt, string $stage, string $module, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWaitLookingOrders(["startAt" => $startAt, "endAt" => $endAt, "stage" => $stage, "module" => $module, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 批量获取一批伙伴处理过的订单
     *
     */
    public static function getStaffHandledOrders (array $staffIds, array $storeIds, bool $isFinished, string $startTime, string $endTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffHandledOrders(["staffIds" => $staffIds, "storeIds" => $storeIds, "isFinished" => $isFinished, "startTime" => $startTime, "endTime" => $endTime, ]);
    }
    /**
     * 获取新系统看片师工作量
     *
     */
    public static function getNewWorkload (string $startTime, string $endTime, int $staffId, string $orgType, int $orgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNewWorkload(["startTime" => $startTime, "endTime" => $endTime, "staffId" => $staffId, "orgType" => $orgType, "orgId" => $orgId, ]);
    }
    /**
     * 通过看片师工号获取流水
     *
     */
    public static function getStreamBySecondRetoucher (int $staffId, string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamBySecondRetoucher(["staffId" => $staffId, "startAt" => $startAt, "endAt" => $endAt, ]);
    }
    /**
     * 通过订单ids获取看片预约时间
     *
     */
    public static function getOrdersEstimateTime (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrdersEstimateTime(["orderIds" => $orderIds, ]);
    }
    /**
     * 获取已完成看片的productIds
     *
     */
    public static function getCompleteLookPhotoProductIds (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCompleteLookPhotoProductIds(["orderId" => $orderId, ]);
    }
    /**
     * 获取服务过某订单的伙伴
     *
     */
    public static function getPaperlessOrderServiceStaffs (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaperlessOrderServiceStaffs(["orderId" => $orderId, ]);
    }
    /**
     * 无纸化订单列表
     *
     */
    public static function paperlessOrderList (array $orderIds, string $stage, array $storeIds, bool $isPrinted, bool $isPosted, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->paperlessOrderList(["orderIds" => $orderIds, "stage" => $stage, "storeIds" => $storeIds, "isPrinted" => $isPrinted, "isPosted" => $isPosted, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 过滤转门店的orderIds
     *
     */
    public static function filterChangeStoreOrderIds (array $orderIds, array $storeIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->filterChangeStoreOrderIds(["orderIds" => $orderIds, "storeIds" => $storeIds, ]);
    }
    /**
     * 获取在线看片信息
     *
     */
    public static function getPictureOnline (array $orderIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPictureOnline(["orderIds" => $orderIds, ]);
    }
    /**
     * isRepairTrial
     *
     */
    public static function isRepairTrial (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->isRepairTrial(["orderId" => $orderId, ]);
    }
    /**
     * setMakeUpAssigns
     *
     */
    public static function setMakeUpAssigns (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Api\Cmd\SetMakeUpAssignCmd $setMakeUpAssignCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setMakeUpAssigns($setMakeUpAssignCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}