<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-10-26 10:36:53
 */
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SecondRetoucher
 */
class SecondRetoucher {
    private static string $serviceName = "ProjectPaperless";

    private static string $className = "Manage\\SecondRetoucher";

    /**
     * 获取门店待审核数【本门店＋转门店】
     *
     */
    public static function getWaitReviewCount (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWaitReviewCount();
    }
    /**
     * 待审核订单列表
     *
     */
    public static function getWaitReviewList (string $orderNum, string $search, string $userName, string $userPhone, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWaitReviewList(["orderNum" => $orderNum, "search" => $search, "userName" => $userName, "userPhone" => $userPhone, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 查询全国待完成订单列表[初始为查询转至本门店订单]
     *
     */
    public static function queryWaitFinishList (string $orderNum, string $userName, string $userPhone, string $brand, string $wholeOrderNum, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryWaitFinishList(["orderNum" => $orderNum, "userName" => $userName, "userPhone" => $userPhone, "brand" => $brand, "wholeOrderNum" => $wholeOrderNum, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 我的审核
     *
     */
    public static function getMyReviewList (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMyReviewList();
    }
    /**
     * 提交审核
     *
     */
    public static function review (string $streamNum, string $evaluate, array $photo, string $note): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->review(["streamNum" => $streamNum, "evaluate" => $evaluate, "photo" => $photo, "note" => $note, ]);
    }
    /**
     * 获取未读流水
     *
     */
    public static function getUnreadCount (): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUnreadCount();
    }
    /**
     * 查看未读流水
     *
     */
    public static function checkUnreadStream (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUnreadStream();
    }
    /**
     * 提示用户有未完成的订单审核
     *
     */
    public static function lostOrderNotify (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->lostOrderNotify();
    }
    /**
     * 清除未完成的订单列表提示
     *
     */
    public static function cleanNotify (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cleanNotify();
    }
    /**
     * 获取在线看片师信息
     *
     */
    public static function getPictureOnlineRetoucher (int $staffId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPictureOnlineRetoucher(["staffId" => $staffId, ]);
    }
    /**
     * 看片审核历史列表
     *
     */
    public static function reviewHistory (string $orderNum, string $userPhone, string $search, string $userName, string $brand, int $page, int $pageSize, bool $searchWithoutStaff, bool $changedStore): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->reviewHistory(["orderNum" => $orderNum, "userPhone" => $userPhone, "search" => $search, "userName" => $userName, "brand" => $brand, "page" => $page, "pageSize" => $pageSize, "searchWithoutStaff" => $searchWithoutStaff, "changedStore" => $changedStore, ]);
    }
    /**
     * 发送看片通知
     *
     */
    public static function sendWatchPhotoNotify (int $orderId, bool $reviewSend): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendWatchPhotoNotify(["orderId" => $orderId, "reviewSend" => $reviewSend, ]);
    }
    /**
     * 看片通知(bms调用,用于自动看片推送)
     *
     */
    public static function autoWatchPhotoNotify (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoWatchPhotoNotify(["orderId" => $orderId, ]);
    }
    /**
     * 看片退单
     *
     */
    public static function reworkStream (string $streamNum, array $photoData, int $assignRetoucherId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->reworkStream(["streamNum" => $streamNum, "photoData" => $photoData, "assignRetoucherId" => $assignRetoucherId, ]);
    }
    /**
     * 看片师已接订单[取多单]
     *
     */
    public static function getOrderOnline (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderOnline();
    }
    /**
     * 看片师再来一单
     *
     */
    public static function kpsOrderAgain (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->kpsOrderAgain();
    }
    /**
     * 绑定审核人id
     *
     */
    public static function bindChecker (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindChecker(["orderId" => $orderId, ]);
    }
    /**
     * 订单详情
     *
     */
    public static function orderDetail (bool $withRetake, int $orderId): \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Cameraman\OrderHistoryInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderDetail(["withRetake" => $withRetake, "orderId" => $orderId, ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Cameraman\OrderHistoryInfoDTO"
        );
    }
    /**
     * 发送授权确认推送
     *
     */
    public static function sendNotice (string $orderNum): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendNotice(["orderNum" => $orderNum, ]);
    }
    /**
     * 获取流水状态
     *
     */
    public static function getStreamStatus (string $streamNum): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamStatus(["streamNum" => $streamNum, ]);
    }
    /**
     * 获取产品贴图模板
     *
     */
    public static function getTemplatesByProductIds (array $productIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTemplatesByProductIds(["productIds" => $productIds, ]);
    }
    /**
     * 提交最终成片
     *
     */
    public static function submitFinalPhoto (string $streamNum, array $photoData): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitFinalPhoto(["streamNum" => $streamNum, "photoData" => $photoData, ]);
    }
    /**
     * 提交最终成片(异步)
     *
     */
    public static function submitFinalPhotoAsync (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\SubmitFinalPhotoAsyncCmd $submitFinalPhotoAsyncCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitFinalPhotoAsync($submitFinalPhotoAsyncCmd);
    }
    /**
     * 摄影师/看片师上传队列上传照片七牛云失败
     *
     */
    public static function uploadQiniuErr (int $streamId, string $path): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->uploadQiniuErr(["streamId" => $streamId, "path" => $path, ]);
    }
    /**
     * hook照片上传
     *
     */
    public static function hookUploadPhoto (int $streamId, string $path, int $photoId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookUploadPhoto(["streamId" => $streamId, "path" => $path, "photoId" => $photoId, ]);
    }
    /**
     * 获取看片师历史上传记录列表
     *
     */
    public static function getHistoryList (string $startTime, string $endTime, string $search, string $orderNum, string $userName, string $userPhone, bool $searchWithoutStaff, bool $changedStore, int $page, int $pageSize): \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\GetHistoryPageDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getHistoryList(["startTime" => $startTime, "endTime" => $endTime, "search" => $search, "orderNum" => $orderNum, "userName" => $userName, "userPhone" => $userPhone, "searchWithoutStaff" => $searchWithoutStaff, "changedStore" => $changedStore, "page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\GetHistoryPageDTO"
        );
    }
    /**
     * 系统自动看片设置成片(RPC调用)
     *
     */
    public static function autoSetFinishedPhoto (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoSetFinishedPhoto(["orderId" => $orderId, ]);
    }
    /**
     * 清除自动看片完成订单的顾客满意片
     *
     */
    public static function clearAutoFinishPhoto (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearAutoFinishPhoto(["orderId" => $orderId, ]);
    }
    /**
     * 获取看片照片数量,时长,看片通知时间 - bms
     *
     */
    public static function getLookingPhotoExtendInfo (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLookingPhotoExtendInfo(["orderId" => $orderId, ]);
    }
    /**
     * 批量获取看片照片数量和时长
     *
     */
    public static function batchLookingPhotoNumbersAndTimes (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchLookingPhotoNumbersAndTimes(["orderIds" => $orderIds, ]);
    }
    /**
     * 看片排单表可约时间
     *
     */
    public static function lookList (string $dateStart, string $dateEnd, int $orderId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->lookList(["dateStart" => $dateStart, "dateEnd" => $dateEnd, "orderId" => $orderId, ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookListDTO[]"
        );
    }
    /**
     * 添加看片排单表预约
     *
     */
    public static function addReservation (int $orderId, string $orderTime): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->addReservation(["orderId" => $orderId, "orderTime" => $orderTime, ]);
    }
    /**
     * 修改看片预约时间
     *
     */
    public static function changeLookPhotoReserveTime (int $orderId, string $lookPhotoReserveTime): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeLookPhotoReserveTime(["orderId" => $orderId, "lookPhotoReserveTime" => $lookPhotoReserveTime, ]);
    }
    /**
     * 取消看片预约
     *
     */
    public static function cancelLookPhotoReserveTime (int $orderId, string $look_photo_reserve_time): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelLookPhotoReserveTime(["orderId" => $orderId, "look_photo_reserve_time" => $look_photo_reserve_time, ]);
    }
    /**
     * 预约看片全局订单查询
     *
     */
    public static function allOrderList (string $orderNo, string $userPhone, int $page, int $pageSize): \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\AllOrderPageDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->allOrderList(["orderNo" => $orderNo, "userPhone" => $userPhone, "page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\AllOrderPageDTO"
        );
    }
    /**
     * 大订单列表
     *
     */
    public static function bigOrderList (string $dateStart, string $dateEnd): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->bigOrderList(["dateStart" => $dateStart, "dateEnd" => $dateEnd, ]);
    }
    /**
     * 大订单一小时内未预约提示
     *
     */
    public static function delaySendBigOrderNotice (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delaySendBigOrderNotice(["order_id" => $order_id, ]);
    }
    /**
     * 看片排单表
     *
     */
    public static function lookingReservation (string $dateStart, string $dateEnd): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->lookingReservation(["dateStart" => $dateStart, "dateEnd" => $dateEnd, ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookingReservationDTO[]"
        );
    }
    /**
     * 看片预约排单表详情
     *
     */
    public static function lookReservationDetail (string $selectDate, int $storeId): \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookReservationDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->lookReservationDetail(["selectDate" => $selectDate, "storeId" => $storeId, ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookReservationDetailDTO"
        );
    }
    /**
     * 调整流水
     *
     */
    public static function cloudStreamTest (int $stream_id, array $raw) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cloudStreamTest(["stream_id" => $stream_id, "raw" => $raw, ]);
    }
    /**
     * 订单退回等待看片
     *
     */
    public static function backWaitLooking (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->backWaitLooking(["orderId" => $orderId, ]);
    }
    /**
     * 通过订单ids获取看片预约时间
     *
     */
    public static function getOrdersEstimateTime (array $orderIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrdersEstimateTime(["orderIds" => $orderIds, ]);
    }
    /**
     * 获取已完成看片的productIds
     *
     */
    public static function getCompleteLookPhotoProductIds (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCompleteLookPhotoProductIds(["orderId" => $orderId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}