<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-10-26 10:36:53
 */
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Cameraman
 */
class Cameraman {
    private static string $serviceName = "ProjectPaperless";

    private static string $className = "Manage\\Cameraman";

    /**
     * 订单添加至摄影师
     *
     */
    public static function pushOrderToCameraman (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->pushOrderToCameraman(["orderId" => $orderId, ]);
    }
    /**
     * 撤回照片(流水维度)
     *
     */
    public static function revokeCloudStream (int $cloudStreamId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokeCloudStream(["cloudStreamId" => $cloudStreamId, ]);
    }
    /**
     * 是否可以撤回流水
     *
     */
    public static function canRevokeStream (int $streamId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->canRevokeStream(["streamId" => $streamId, ]);
    }
    /**
     * 云端流水详情
     *
     */
    public static function getCloudStreamInfo (int $cloudStreamId): \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Cameraman\CloudStreamInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCloudStreamInfo(["cloudStreamId" => $cloudStreamId, ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Cameraman\CloudStreamInfoDTO"
        );
    }
    /**
     * 多余底片上传
     *
     */
    public static function submitToCloudExtra (int $orderId, int $productId, array $photos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitToCloudExtra(["orderId" => $orderId, "productId" => $productId, "photos" => $photos, ]);
    }
    /**
     * 获取订单历史上传记录详情
     *
     */
    public static function getHistoryInfo (int $orderId): \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Cameraman\OrderHistoryInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getHistoryInfo(["orderId" => $orderId, ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Cameraman\OrderHistoryInfoDTO"
        );
    }
    /**
     * 撤回照片(订单维度)
     *
     */
    public static function revokeOrder (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokeOrder(["orderId" => $orderId, ]);
    }
    /**
     * 批量获取流水详情(通过流水id)
     *
     */
    public static function batchGetStreamInfoByIds (array $cloudStreamIds, string $brand): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchGetStreamInfoByIds(["cloudStreamIds" => $cloudStreamIds, "brand" => $brand, ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Cameraman\OrderProductStreamDTO[]"
        );
    }
    /**
     * 获取赠送底片记录统计
     *
     */
    public static function getTotalCount (string $startTime, string $endTime, string $orderNum, string $userName, string $userPhone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTotalCount(["startTime" => $startTime, "endTime" => $endTime, "orderNum" => $orderNum, "userName" => $userName, "userPhone" => $userPhone, ]);
    }
    /**
     * 获取摄影师赠送底片上传记录列表
     *
     */
    public static function getExtraHistoryList (string $startTime, string $endTime, string $orderNum, string $userName, string $userPhone, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExtraHistoryList(["startTime" => $startTime, "endTime" => $endTime, "orderNum" => $orderNum, "userName" => $userName, "userPhone" => $userPhone, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 撤回赠送底片上传
     *
     */
    public static function revokeSubmitExtra (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokeSubmitExtra(["id" => $id, ]);
    }
    /**
     * 重新上传多余底片
     *
     */
    public static function reSubmitExtra (int $id, array $photos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reSubmitExtra(["id" => $id, "photos" => $photos, ]);
    }
    /**
     * 多余底片详情
     *
     */
    public static function getExtraPhotoDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExtraPhotoDetail(["id" => $id, ]);
    }
    /**
     * 获取剩余传输底片数量
     *
     */
    public static function remainingPhoto (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remainingPhoto(["orderId" => $orderId, ]);
    }
    /**
     * 当前门店是否需要上传优秀底片
     *
     */
    public static function excellencePhotoUploadSetting () {
        return RpcClass::getClass(self::$serviceName, self::$className)->excellencePhotoUploadSetting();
    }
    /**
     * 判断是否为上海蓝标店
     *
     */
    public static function shanghaiBlueStore (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->shanghaiBlueStore();
    }
    /**
     * 获取订单取片时间
     *
     */
    public static function getOrderTakeTime (int $orderId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderTakeTime(["orderId" => $orderId, ]);
    }
    /**
     * 获取订单绑定的摄影师信息及权限
     *
     */
    public static function getOrderCameramanInfoBaseAuth (int $orderId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderCameramanInfoBaseAuth(["orderId" => $orderId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}