<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cloudProductInfoByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Product\Dto\ProductInfoDto $params)
 * @method productRetouchStyleByParams(array $params)
 * @method evaluateRetoucherByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\EvaluateRetoucherDto $params)
 * @method cloudTechnologyDetailByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Product\Dto\ProductInfoDto $dto
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Product\Dto\ProductInfoResDto[]
     */
    public static function cloudProductInfo (\Mainto\Bridge\Structs\ProjectPaperless\Product\Dto\ProductInfoDto $dto) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->cloudProductInfo($dto),
            "\Mainto\Bridge\Structs\ProjectPaperless\Product\Dto\ProductInfoResDto[]"
        );
    }


    /**
     * 获取云端产品的修图风格
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productRetouchStyle (int $productId) {
        return self::getClass()->productRetouchStyle([
            "productId" => $productId,
        ]);
    }

    /**
     * 评价修图师风格
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\EvaluateRetoucherDto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function evaluateRetoucher (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\EvaluateRetoucherDto $dto) {
        return self::getClass()->evaluateRetoucher($dto);
    }


    /**
     * 获取产品的技术要点
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cloudTechnologyDetail (int $productId) {
        return self::getClass()->cloudTechnologyDetail([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}