<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setPrintByParams(array $params)
 * @method detailByParams(array $params)
 * @method getPhotoSizeByIdsByParams(array $params)
 * @method changeTakePhotoTypeByParams(array $params)
 * @method addPostNumByParams(array $params)
 * @method checkConformOnlineOrderByParams(array $params)
 * @method batchCheckConformOnlineOrderByParams(array $params)
 */
class PictureOnline {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 在线看片设置打印
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setPrint (string $recordNo) {
        return self::getClass()->setPrint([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 在线看片详情
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (string $orderNum) {
        return self::getClass()->detail([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 根据看片单ids获取打印尺寸
     *
     * @param  array $ids 看片单ids [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PictureOnline\PhotoSizeDTO[]
     */
    public static function getPhotoSizeByIds (array $ids) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPhotoSizeByIds([
                            "ids" => $ids,
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\PictureOnline\PhotoSizeDTO[]"
        );
    }

    /**
     * 修改取片方式
     *
     * @support  string $recordNo 看片单号 [ require true ]
     * @support  string $takeType 取片方式 [ require true ]
     * @support  mixed $postInfo 取片信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeTakePhotoType () {
        return self::getClass()->changeTakePhotoType([
        ]);
    }

    /**
     * 标记发件
     *
     * @support  string $recordNo 看片单号 [ require true ]
     * @support  string $postNum 邮递单号 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addPostNum () {
        return self::getClass()->addPostNum([
        ]);
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $storeId 门店 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkConformOnlineOrder (string $orderNo, int $storeId) {
        return self::getClass()->checkConformOnlineOrder([
            "orderNo" => $orderNo,
            "storeId" => $storeId,
        ]);
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  array $orderInfo 订单信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchCheckConformOnlineOrder (array $orderInfo) {
        return self::getClass()->batchCheckConformOnlineOrder([
            "orderInfo" => $orderInfo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\PictureOnline');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\PictureOnline');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}