<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getWaitReviewCountByParams(array $params)
 * @method getWaitReviewListByParams(array $params)
 * @method queryWaitFinishListByParams(array $params)
 * @method getMyReviewListByParams(array $params)
 * @method reviewByParams(array $params)
 * @method getUnreadCountByParams(array $params)
 * @method checkUnreadStreamByParams(array $params)
 * @method lostOrderNotifyByParams(array $params)
 * @method cleanNotifyByParams(array $params)
 * @method getPictureOnlineRetoucherByParams(array $params)
 * @method reviewHistoryByParams(array $params)
 * @method sendWatchPhotoNotifyByParams(array $params)
 * @method autoWatchPhotoNotifyByParams(array $params)
 * @method reworkStreamByParams(array $params)
 * @method getOrderOnlineByParams(array $params)
 * @method kpsOrderAgainByParams(array $params)
 * @method bindCheckerByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method sendNoticeByParams(array $params)
 * @method getStreamStatusByParams(array $params)
 * @method getTemplatesByProductIdsByParams(array $params)
 * @method submitFinalPhotoByParams(array $params)
 * @method submitFinalPhotoAsyncByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\SubmitFinalPhotoAsyncCmd $params)
 * @method uploadQiniuErrByParams(array $params)
 * @method hookUploadPhotoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method hookCloudFinishStreamByParams(array $params)
 * @method autoSetFinishedPhotoByParams(array $params)
 * @method clearAutoFinishPhotoByParams(array $params)
 * @method hookCloudDeleteStreamByParams(array $params)
 * @method hookPictureOnlineTakeOrderByParams(array $params)
 * @method hookPictureOnlineCompleteOrderByParams(array $params)
 * @method hookHimoSetWorkloadsByParams(array $params)
 * @method getLookingPhotoExtendInfoByParams(array $params)
 * @method batchLookingPhotoNumbersAndTimesByParams(array $params)
 * @method lookListByParams(array $params)
 * @method addReservationByParams(array $params)
 * @method changeLookPhotoReserveTimeByParams(array $params)
 * @method cancelLookPhotoReserveTimeByParams(array $params)
 * @method allOrderListByParams(array $params)
 * @method bigOrderListByParams(array $params)
 * @method delaySendBigOrderNoticeByParams(array $params)
 * @method lookingReservationByParams(array $params)
 * @method lookReservationDetailByParams(array $params)
 * @method cloudStreamTestByParams(array $params)
 * @method backWaitLookingByParams(array $params)
 * @method testReserveByParams(array $params)
 * @method getOrdersEstimateTimeByParams(array $params)
 * @method getCompleteLookPhotoProductIdsByParams(array $params)
 */
class SecondRetoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店待审核数【本门店＋转门店】
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getWaitReviewCount () {
        return self::getClass()->getWaitReviewCount();
    }

    /**
     * 待审核订单列表
     *
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 姓名 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\WaitReviewPageDTO
     */
    public static function getWaitReviewList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getWaitReviewList([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\WaitReviewPageDTO"
        );
    }

    /**
     * 查询全国待完成订单列表[初始为查询转至本门店订单]
     *
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 姓名 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @support  string $wholeOrderNum 全国范围订单号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\WaitReviewPageDTO
     */
    public static function queryWaitFinishList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->queryWaitFinishList([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\WaitReviewPageDTO"
        );
    }

    /**
     * 我的审核
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\MyReviewListDTO[]
     */
    public static function getMyReviewList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMyReviewList(),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\MyReviewListDTO[]"
        );
    }

    /**
     * 提交审核
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @support  string $evaluate 评价 [ require false ]
     * @support  array $photo 照片 [ require false ]
     * @support  string $note 评语 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function review () {
        return self::getClass()->review([
        ]);
    }

    /**
     * 获取未读流水
     *
     * @throws  \Exception
     * @return  int
     */
    public static function getUnreadCount () {
        return self::getClass()->getUnreadCount();
    }

    /**
     * 查看未读流水
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function checkUnreadStream () {
        return self::getClass()->checkUnreadStream();
    }

    /**
     * 提示用户有未完成的订单审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function lostOrderNotify () {
        return self::getClass()->lostOrderNotify();
    }

    /**
     * 清除未完成的订单列表提示
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cleanNotify () {
        return self::getClass()->cleanNotify();
    }

    /**
     * 获取在线看片师信息
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPictureOnlineRetoucher (int $staffId) {
        return self::getClass()->getPictureOnlineRetoucher([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 看片审核历史列表
     *
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  string $userName 姓名 [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @support  bool $searchWithoutStaff 不根据伙伴查询 [ require false ]
     * @support  bool $changedStore 是否为转门店数据 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\ReviewHistoryPageDTO
     */
    public static function reviewHistory () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->reviewHistory([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\ReviewHistoryPageDTO"
        );
    }

    /**
     * 发送看片通知
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendWatchPhotoNotify () {
        return self::getClass()->sendWatchPhotoNotify([
        ]);
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function autoWatchPhotoNotify (int $orderId) {
        return self::getClass()->autoWatchPhotoNotify([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 看片退单
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  array $photoData 照片信息 [ require true ]
     * @param  int $assignRetoucherId 退回指定修图师的流水，不指定为随机 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function reworkStream (string $streamNum, array $photoData, int $assignRetoucherId = null) {
        return self::getClass()->reworkStream([
            "streamNum" => $streamNum,
            "photoData" => $photoData,
            "assignRetoucherId" => $assignRetoucherId,
        ]);
    }

    /**
     * 看片师已接订单[取多单]
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\GetOrderOnlineDTO[]
     */
    public static function getOrderOnline () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderOnline(),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\GetOrderOnlineDTO[]"
        );
    }

    /**
     * 看片师再来一单
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\KpsOrderAgainDTO
     */
    public static function kpsOrderAgain () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->kpsOrderAgain(),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\KpsOrderAgainDTO"
        );
    }

    /**
     * 绑定审核人id
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindChecker () {
        return self::getClass()->bindChecker([
        ]);
    }

    /**
     * 订单详情
     *
     * @support  bool $withRetake 是否显示删除的流水信息 [ require false ]
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Cameraman\OrderHistoryInfoDTO
     */
    public static function orderDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->orderDetail([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\Cameraman\OrderHistoryInfoDTO"
        );
    }

    /**
     * 发送授权确认推送
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendNotice () {
        return self::getClass()->sendNotice([
        ]);
    }

    /**
     * 获取流水状态
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamStatus () {
        return self::getClass()->getStreamStatus([
        ]);
    }

    /**
     * 获取产品贴图模板
     *
     * @param  array $productIds 产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTemplatesByProductIds (array $productIds) {
        return self::getClass()->getTemplatesByProductIds([
            "productIds" => $productIds,
        ]);
    }

    /**
     * 提交最终成片
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  array $photoData 照片数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submitFinalPhoto (string $streamNum, array $photoData) {
        return self::getClass()->submitFinalPhoto([
            "streamNum" => $streamNum,
            "photoData" => $photoData,
        ]);
    }

    /**
     * 提交最终成片(异步)
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\SubmitFinalPhotoAsyncCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function submitFinalPhotoAsync (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\SubmitFinalPhotoAsyncCmd $cmd) {
        return self::getClass()->submitFinalPhotoAsync($cmd);
    }


    /**
     * 摄影师/看片师上传队列上传照片七牛云失败
     *
     * @param  int $streamId 流水id [ require true ]
     * @param  string $path 照片路径 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function uploadQiniuErr (int $streamId, string $path) {
        return self::getClass()->uploadQiniuErr([
            "streamId" => $streamId,
            "path" => $path,
        ]);
    }

    /**
     * hook照片上传
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  string $path 照片路径 [ require true ]
     * @param  int $photoId 照片id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookUploadPhoto (string $streamNum, string $path, int $photoId = 0) {
        return self::getClass()->hookUploadPhoto([
            "streamNum" => $streamNum,
            "path" => $path,
            "photoId" => $photoId,
        ]);
    }

    /**
     * 获取看片师历史上传记录列表
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 顾客姓名 [ require false ]
     * @support  string $userPhone 顾客手机号 [ require false ]
     * @support  bool $searchWithoutStaff 不根据伙伴查询 [ require false ]
     * @support  bool $changedStore 是否为转门店数据 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\GetHistoryPageDTO
     */
    public static function getHistoryList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getHistoryList([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\GetHistoryPageDTO"
        );
    }

    /**
     * 接收云端流水完成事件
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudFinishStream (string $stream_num) {
        return self::getClass()->hookCloudFinishStream([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function autoSetFinishedPhoto (int $orderId) {
        return self::getClass()->autoSetFinishedPhoto([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 清除自动看片完成订单的顾客满意片
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function clearAutoFinishPhoto (int $orderId) {
        return self::getClass()->clearAutoFinishPhoto([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 接收云端流水删除事件
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @param  int $delete_operator_id 操作删除流水的员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudDeleteStream (string $stream_num, int $delete_operator_id) {
        return self::getClass()->hookCloudDeleteStream([
            "stream_num" => $stream_num,
            "delete_operator_id" => $delete_operator_id,
        ]);
    }

    /**
     * 接收在线看片接单事件
     *
     * @param  string $outsideNo 订单号 [ require true ]
     * @param  int $watcherId 看片师工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPictureOnlineTakeOrder (string $outsideNo, int $watcherId) {
        return self::getClass()->hookPictureOnlineTakeOrder([
            "outsideNo" => $outsideNo,
            "watcherId" => $watcherId,
        ]);
    }

    /**
     * 接收在线看片完成事件
     *
     * @param  string $outsideNo 订单号 [ require true ]
     * @param  bool $isDirectFinish 是否是直接满意 [ require true ]
     * @param  array $photos 本次在线看片完成的照片 [ require true ]
     * @param  int $watcherId 本次在线看片完成的照片 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPictureOnlineCompleteOrder (string $outsideNo, bool $isDirectFinish, array $photos, int $watcherId = null) {
        return self::getClass()->hookPictureOnlineCompleteOrder([
            "outsideNo" => $outsideNo,
            "isDirectFinish" => $isDirectFinish,
            "photos" => $photos,
            "watcherId" => $watcherId,
        ]);
    }

    /**
     * 接收录工作量事件
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  array $workloads 工作量数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookHimoSetWorkloads (int $orderId, array $workloads) {
        return self::getClass()->hookHimoSetWorkloads([
            "orderId" => $orderId,
            "workloads" => $workloads,
        ]);
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\GetLookingPhotoExtendInfoDTO
     */
    public static function getLookingPhotoExtendInfo (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getLookingPhotoExtendInfo([
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\GetLookingPhotoExtendInfoDTO"
        );
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  array $orderIds 订单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchLookingPhotoNumbersAndTimes (array $orderIds) {
        return self::getClass()->batchLookingPhotoNumbersAndTimes([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 看片排单表可约时间
     *
     * @param  string $dateStart 开始日期 [ require true ]
     * @param  string $dateEnd 结束日期 [ require true ]
     * @param  int $orderId 订单Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookListDTO[]
     */
    public static function lookList (string $dateStart, string $dateEnd, int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->lookList([
                            "dateStart" => $dateStart,
                            "dateEnd" => $dateEnd,
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookListDTO[]"
        );
    }

    /**
     * 添加看片排单表预约
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  string $orderTime 节点时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addReservation () {
        return self::getClass()->addReservation([
        ]);
    }

    /**
     * 修改看片预约时间
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $lookPhotoReserveTime 看片预约时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeLookPhotoReserveTime (int $orderId, string $lookPhotoReserveTime) {
        return self::getClass()->changeLookPhotoReserveTime([
            "orderId" => $orderId,
            "lookPhotoReserveTime" => $lookPhotoReserveTime,
        ]);
    }

    /**
     * 取消看片预约
     *
     * @param  int $orderId 订单id [ require true ]
     * @support  string $look_photo_reserve_time 取消预约时间 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelLookPhotoReserveTime (int $orderId) {
        return self::getClass()->cancelLookPhotoReserveTime([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 预约看片全局订单查询
     *
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\AllOrderPageDTO
     */
    public static function allOrderList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->allOrderList([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\AllOrderPageDTO"
        );
    }

    /**
     * 大订单列表
     *
     * @param  string $dateStart 开始日期 [ require true ]
     * @param  string $dateEnd 截止日期 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bigOrderList (string $dateStart, string $dateEnd) {
        return self::getClass()->bigOrderList([
            "dateStart" => $dateStart,
            "dateEnd" => $dateEnd,
        ]);
    }

    /**
     * 大订单一小时内未预约提示
     *
     * @param  int $order_id 订单Id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delaySendBigOrderNotice (int $order_id) {
        return self::getClass()->delaySendBigOrderNotice([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 看片排单表
     *
     * @param  string $dateStart 开始日期 [ require true ]
     * @param  string $dateEnd 截止日期 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookingReservationDTO[]
     */
    public static function lookingReservation (string $dateStart, string $dateEnd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->lookingReservation([
                            "dateStart" => $dateStart,
                            "dateEnd" => $dateEnd,
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookingReservationDTO[]"
        );
    }

    /**
     * 看片预约排单表详情
     *
     * @support  string $selectDate 日期 [ require true ]
     * @support  int $storeId 门店 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookReservationDetailDTO
     */
    public static function lookReservationDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->lookReservationDetail([
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\DTO\SecondRetoucher\LookReservationDetailDTO"
        );
    }

    /**
     * 调整流水
     *
     * @param  int $stream_id stream_id [ require true ]
     * @param  array $raw 需要修改的数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cloudStreamTest (int $stream_id, array $raw) {
        return self::getClass()->cloudStreamTest([
            "stream_id" => $stream_id,
            "raw" => $raw,
        ]);
    }

    /**
     * 订单退回等待看片
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function backWaitLooking (int $orderId) {
        return self::getClass()->backWaitLooking([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 测试站点
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function testReserve (int $orderId) {
        return self::getClass()->testReserve([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 通过订单ids获取看片预约时间
     *
     * @param  array $orderIds 订单id数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrdersEstimateTime (array $orderIds) {
        return self::getClass()->getOrdersEstimateTime([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 获取已完成看片的productIds
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCompleteLookPhotoProductIds (int $orderId) {
        return self::getClass()->getCompleteLookPhotoProductIds([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\SecondRetoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\SecondRetoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}