<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queueToWaitingByParams(array $params)
 * @method removeStaffHangByParams(array $params)
 * @method dailyCleanByParams(array $params)
 * @method refreshProductIdsByParams(array $params)
 * @method dingUsersWhenOrderHangingTimeOutByParams(array $params)
 * @method cronSendXiuNotifyByParams(array $params)
 * @method cronClearExpiredReservationByParams(array $params)
 * @method cronClearOrderUploadChangeSalesByParams(array $params)
 * @method cronClearOrderRepeatLookPhotoByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天9-23点每分钟执行-签到排队状态自动进入等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queueToWaiting () {
        return self::getClass()->queueToWaiting();
    }

    /**
     * 每天9-23点每分钟执行-对超过1小时挂起的伙伴解除挂起
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStaffHang () {
        return self::getClass()->removeStaffHang();
    }

    /**
     * 每天4点执行-清空前一日流程记录
     *
     * @support  int $storeId 门店id [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dailyClean () {
        return self::getClass()->dailyClean([
        ]);
    }

    /**
     * 每小时执行-重刷产品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshProductIds () {
        return self::getClass()->refreshProductIds();
    }

    /**
     * 签到排队状态自动进入化妆等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function dingUsersWhenOrderHangingTimeOut () {
        return self::getClass()->dingUsersWhenOrderHangingTimeOut();
    }

    /**
     * cronSendXiuNotify
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronSendXiuNotify () {
        return self::getClass()->cronSendXiuNotify();
    }

    /**
     * 定时清理过号
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronClearExpiredReservation () {
        return self::getClass()->cronClearExpiredReservation();
    }

    /**
     * 定时清理订单上传更新标记
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronClearOrderUploadChangeSales () {
        return self::getClass()->cronClearOrderUploadChangeSales();
    }

    /**
     * 日清售后二次看片的订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronClearOrderRepeatLookPhoto () {
        return self::getClass()->cronClearOrderRepeatLookPhoto();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}