<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getClothsByParams(array $params)
 * @method continueToMakeUpByParams(array $params)
 * @method getMakeUpAssistantsByParams(array $params)
 * @method completeMakeUpByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\Cmd\CompleteProcessCmd $params)
 * @method completePhotographyByParams(array $params)
 * @method completeAndHangByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\Cmd\CompleteProcessCmd $params)
 * @method goSelectPhotoByParams(array $params)
 * @method assignAssistanceByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\Cmd\AssignAssistanceCmd $params)
 * @method orderAgainByParams(array $params)
 * @method takeOrderByParams(array $params)
 * @method saveNoteByParams(array $params)
 * @method getCloudProductInfoByParams(array $params)
 */
class Process {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店产品可选衣服
     *
     * @support  int $processId 流程id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloths () {
        return self::getClass()->getCloths([
        ]);
    }

    /**
     * 主化妆师继续化妆
     *
     * @support  int $processId 流程id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function continueToMakeUp () {
        return self::getClass()->continueToMakeUp([
        ]);
    }

    /**
     * 获取多产品协作信息
     *
     * @support  int $processId 流程id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMakeUpAssistants () {
        return self::getClass()->getMakeUpAssistants([
        ]);
    }

    /**
     * 完成化妆
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\Cmd\CompleteProcessCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function completeMakeUp (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\Cmd\CompleteProcessCmd $cmd) {
        return self::getClass()->completeMakeUp($cmd);
    }


    /**
     * 完成摄影
     *
     * @support  int $processId 流程id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function completePhotography () {
        return self::getClass()->completePhotography([
        ]);
    }

    /**
     * 完成并挂起
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\Cmd\CompleteProcessCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeAndHang (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\Cmd\CompleteProcessCmd $cmd) {
        return self::getClass()->completeAndHang($cmd);
    }


    /**
     * 完成摄影去选片
     *
     * @support  int $processId 流程id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function goSelectPhoto () {
        return self::getClass()->goSelectPhoto([
        ]);
    }

    /**
     * 指派协作化妆师
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\Cmd\AssignAssistanceCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function assignAssistance (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\User\Cmd\AssignAssistanceCmd $cmd) {
        return self::getClass()->assignAssistance($cmd);
    }


    /**
     * 再来一单
     *
     * @support  int $orderId 订单id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderAgain () {
        return self::getClass()->orderAgain([
        ]);
    }

    /**
     * 接新订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeOrder () {
        return self::getClass()->takeOrder();
    }

    /**
     * 更新流程备注信息
     *
     * @support  int $processId 流程id [ require false ]
     * @support  string $note 备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveNote () {
        return self::getClass()->saveNote([
        ]);
    }

    /**
     * 获取云端产品信息
     *
     * @support  int $processId 流程id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCloudProductInfo () {
        return self::getClass()->getCloudProductInfo([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'User\Process');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'User\Process');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}