<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userSignInByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\UserSignInCmd $params)
 * @method retouchSignInByParams(array $params)
 * @method reviewStoreListByParams(array $params)
 * @method technicalPointsByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\OrderDto $params)
 * @method technicalPointsHistoryByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\OrderDto $params)
 * @method updateTechnicalPointsByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\UpdateTechnicalPointsDto $params)
 * @method getProcessInfoByParams(array $params)
 */
class Process {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 前台签到
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\UserSignInCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function userSignIn (\Mainto\Bridge\Structs\ProjectPaperless\Controllers\Manage\Cmd\UserSignInCmd $cmd) {
        return self::getClass()->userSignIn($cmd);
    }


    /**
     * 看片签到
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $retoucherId 指定的看片师id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function retouchSignIn () {
        return self::getClass()->retouchSignIn([
        ]);
    }

    /**
     * 支持预约看片门店列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewStoreList () {
        return self::getClass()->reviewStoreList();
    }

    /**
     * 获取订单下产品的技术要点
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\OrderDto $dto
     * @throws  \Exception
     * @return  array
     */
    public static function technicalPoints (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\OrderDto $dto) {
        return self::getClass()->technicalPoints($dto);
    }


    /**
     * 获取订单下产品的技术要点（包含被删除的技术要点）
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\OrderDto $dto
     * @throws  \Exception
     * @return  array
     */
    public static function technicalPointsHistory (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\OrderDto $dto) {
        return self::getClass()->technicalPointsHistory($dto);
    }


    /**
     * 更新订单下产品的技术要点
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\UpdateTechnicalPointsDto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function updateTechnicalPoints (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\UpdateTechnicalPointsDto $dto) {
        return self::getClass()->updateTechnicalPoints($dto);
    }


    /**
     * 获取process信息
     *
     * @param  int $processId processId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Process\DTO\ProcessInfoDTO
     */
    public static function getProcessInfo (int $processId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProcessInfo([
                            "processId" => $processId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectPaperless\Process\DTO\ProcessInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Process');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Process');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}