<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchByParams(array $params)
 * @method uploadListByParams(array $params)
 * @method tabRefundNotDealWithByParams(array $params)
 * @method tabOrderUpdateNotDealWithByParams(array $params)
 * @method variousUploadedTotalByParams(array $params)
 * @method uploadPhotoCloudByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\UploadPhotoCloudDto $params)
 * @method uploadPhotoCloudAsyncByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\UploadPhotoCloudAsyncDto $params)
 * @method hookUploadPhotoByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\PhotoInfoDTO $params)
 */
class UploadRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 摄影师中心：搜索订单
     *
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $userName 顾客姓名 [ require false ]
     * @support  string $userPhone 顾客手机号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function search () {
        return self::getClass()->search([
        ]);
    }

    /**
     * 上传记录列表
     *
     * @support  string $type 查询类型 [ require true ]
     * @support  string $searchTimeField 搜索字段 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $sortField 排序字段 [ require false ]
     * @support  string $sort 排序方式 [ require false ]
     * @support  int $orderId 订单id [ require false ]
     * @support  bool $updatable 查询有更新的订单 [ require false ]
     * @support  bool $todayTakeOrder 是否查询今日新接单 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 页码 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function uploadList () {
        return self::getClass()->uploadList([
        ]);
    }

    /**
     * 标记退款中不需要处理
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $saleId 销售id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function tabRefundNotDealWith () {
        return self::getClass()->tabRefundNotDealWith([
        ]);
    }

    /**
     * 标记订单无需处理
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function tabOrderUpdateNotDealWith () {
        return self::getClass()->tabOrderUpdateNotDealWith([
        ]);
    }

    /**
     * 获取各上传总数
     *
     * @support  string $type 查询类型 [ require false ]
     * @support  string $searchTimeField 搜索字段 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  bool $todayTakeOrder 是否查询今日新接单 [ require false ]
     * @support  int $orderId 订单id [ require false ]
     * @support  bool $updatable 查询有更新的订单 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function variousUploadedTotal () {
        return self::getClass()->variousUploadedTotal([
        ]);
    }

    /**
     * 上传照片到云端
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\UploadPhotoCloudDto $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function uploadPhotoCloud (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\UploadPhotoCloudDto $dto) {
        return self::getClass()->uploadPhotoCloud($dto);
    }


    /**
     * 异步上传照片到云端
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\UploadPhotoCloudAsyncDto $dto
     * @throws  \Exception
     * @return  int
     */
    public static function uploadPhotoCloudAsync (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\UploadPhotoCloudAsyncDto $dto) {
        return self::getClass()->uploadPhotoCloudAsync($dto);
    }


    /**
     * hook照片上传
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\PhotoInfoDTO $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function hookUploadPhoto (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\PhotoInfoDTO $dto) {
        return self::getClass()->hookUploadPhoto($dto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\UploadRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\UploadRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}