<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method factoryProductionByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Logistics\DTO\FactoryProductionDto $params)
 * @method saveLogisticsInformationByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Logistics\DTO\LogisticsInformationDto $params)
 * @method beginTransitByParams(array $params)
 * @method deliveryByParams(array $params)
 */
class Logistics {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 运送工厂制作
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Logistics\DTO\FactoryProductionDto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function factoryProduction (\Mainto\Bridge\Structs\ProjectPaperless\Logistics\DTO\FactoryProductionDto $dto) {
        return self::getClass()->factoryProduction($dto);
    }


    /**
     * 保存物流信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Logistics\DTO\LogisticsInformationDto $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveLogisticsInformation (\Mainto\Bridge\Structs\ProjectPaperless\Logistics\DTO\LogisticsInformationDto $dto) {
        return self::getClass()->saveLogisticsInformation($dto);
    }


    /**
     * 物流开始寄送
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function beginTransit (int $orderId) {
        return self::getClass()->beginTransit([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 物流签收
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delivery (int $orderId) {
        return self::getClass()->delivery([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Logistics');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Logistics');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}