<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method delaySendNoticeBySelectPhotoTimeout15MinuteByParams(array $params)
 * @method delaySendNoticeBySelectPhotoTimeout30MinuteByParams(array $params)
 * @method changeSalesByParams(array $params)
 * @method deleteOrderByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method refundOrderByParams(array $params)
 * @method partRefundOrderByParams(array $params)
 * @method syncPassProductIdsByParams(array $params)
 * @method orderRetakeSaleByParams(array $params)
 * @method retakeOrderCancelNotifyByParams(array $params)
 * @method addPhotoToPoolByParams(array $params)
 * @method orderUpgradeSkuByParams(array $params)
 * @method createPhotographyCompletedPaperlessByParams(array $params)
 * @method orderServiceCompletedSendFinishPhotoByParams(array $params)
 */
class MessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 选片超时15分钟通知
     *
     * @support  int $processId 流程Id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delaySendNoticeBySelectPhotoTimeout15Minute () {
        return self::getClass()->delaySendNoticeBySelectPhotoTimeout15Minute([
        ]);
    }

    /**
     * 选片超时30分钟通知
     *
     * @support  int $process_id 流程Id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delaySendNoticeBySelectPhotoTimeout30Minute () {
        return self::getClass()->delaySendNoticeBySelectPhotoTimeout30Minute([
        ]);
    }

    /**
     * 订单修改拍摄产品通知
     *
     * @support  int $orderId 订单Id [ require false ]
     * @support  int $storeId 门店Id [ require false ]
     * @support  int $inputStaffId 操作人id [ require false ]
     * @support  array $createSaleList 新增拍摄产品 [ require false ]
     * @support  array $removeSaleList 删除拍摄产品 [ require false ]
     * @support  array $modifySaleList 拍摄产品变更 [ require false ]
     * @support  array $unModifySaleList 拍摄产品未变化 [ require false ]
     * @support  array $replaceSaleList 替换拍摄产品 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeSales () {
        return self::getClass()->changeSales([
        ]);
    }

    /**
     * 删除订单(用户删除 or bms删除)
     *
     * @support  int $orderId 订单Id [ require false ]
     * @support  int $storeId 门店Id [ require false ]
     * @support  int $userId 用户Id [ require false ]
     * @support  int $orderUserId 下单用户Id [ require false ]
     * @support  bool $userDeleted 是否是用户删除 [ require false ]
     * @support  string $deletedAt 删除时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOrder () {
        return self::getClass()->deleteOrder([
        ]);
    }

    /**
     * 关闭订单流程
     *
     * @support  int $orderId 订单Id [ require false ]
     * @support  int $storeId 门店Id [ require false ]
     * @support  string $changeReserveTime 预约时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder () {
        return self::getClass()->closeOrder([
        ]);
    }

    /**
     * 退回到等待拍摄流程
     *
     * @support  int $orderId 订单Id [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recoverWaitShooting () {
        return self::getClass()->recoverWaitShooting([
        ]);
    }

    /**
     * 订单退款通知
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  int $storeId 门店Id [ require true ]
     * @support  array $closedSaleIds 退款sale_id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundOrder () {
        return self::getClass()->refundOrder([
        ]);
    }

    /**
     * partRefundOrder
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  int $storeId 门店Id [ require true ]
     * @support  array $orderSkuList 退款后skuList [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function partRefundOrder () {
        return self::getClass()->partRefundOrder([
        ]);
    }

    /**
     * 更新通关产品ids
     *
     * @support  int $staffId 伙伴id [ require false ]
     * @support  array $productIds 通关产品ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncPassProductIds () {
        return self::getClass()->syncPassProductIds([
        ]);
    }

    /**
     * orderRetakeSale
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  int $retakeNewStoreId 重拍之后新门店id [ require false ]
     * @support  int $retakeNewOrderId 重拍之后新建的订单id [ require false ]
     * @support  bool $skuAllRetake 是否全部重拍 [ require false ]
     * @support  array $retakeOrderSakeSku 重拍的拍摄产品 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderRetakeSale () {
        return self::getClass()->orderRetakeSale([
        ]);
    }

    /**
     * 重拍订单超时关闭通知
     *
     * @support  int $afterOrderId 重拍后新建订单的订单Id [ require true ]
     * @support  int $afterStoreId 重拍后新建订单的门店Id [ require true ]
     * @support  string $cancelType 取消类型，auto：系统操作(超时)，hand：手动操作 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function retakeOrderCancelNotify () {
        return self::getClass()->retakeOrderCancelNotify([
        ]);
    }

    /**
     * 添加流水照片到抽片池
     *
     * @support  array $streamIds 流水id [ require true ]
     * @support  int $staffId 员工id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $poolType 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPhotoToPool () {
        return self::getClass()->addPhotoToPool([
        ]);
    }

    /**
     * 订单完成之后的加修加印推送（无新产品）
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  array $upgradeSkuList 加修加印信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderUpgradeSku () {
        return self::getClass()->orderUpgradeSku([
        ]);
    }

    /**
     * 创建完成拍摄的订单
     *
     * @support  int $orderId 订单Id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPhotographyCompletedPaperless () {
        return self::getClass()->createPhotographyCompletedPaperless([
        ]);
    }

    /**
     * 订单服务完成发送看片完成数据
     *
     * @support  int $orderId 订单Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderServiceCompletedSendFinishPhoto () {
        return self::getClass()->orderServiceCompletedSendFinishPhoto([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'MessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'MessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}