<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPaperlessOrderByParams(array $params)
 * @method getPaperlessOrderByOrderIdsByParams(array $params)
 * @method getActiveStageRecordByParams(array $params)
 * @method getWaitLookingOrdersByParams(array $params)
 * @method getStaffHandledOrdersByParams(array $params)
 * @method getNewWorkloadByParams(array $params)
 * @method getStreamBySecondRetoucherByParams(array $params)
 * @method getOrdersEstimateTimeByParams(array $params)
 * @method getCompleteLookPhotoProductIdsByParams(array $params)
 * @method getPaperlessOrderServiceStaffsByParams(array $params)
 * @method paperlessOrderListByParams(array $params)
 * @method getPictureOnlineByParams(array $params)
 */
class PaperlessOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 无纸化订单信息
     *
     * @param  int $orderId orderId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPaperlessOrder (int $orderId) {
        return self::getClass()->getPaperlessOrder([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 批量获取无纸化订单信息
     *
     * @param  array $orderIds orderIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPaperlessOrderByOrderIds (array $orderIds) {
        return self::getClass()->getPaperlessOrderByOrderIds([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 获取某个进行中阶段的数据
     *
     * @param  string $createStartAt 开始时间 [ require true ]
     * @param  string $createEndAt 结束时间 [ require true ]
     * @param  string $stage 状态 [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActiveStageRecord (string $createStartAt, string $createEndAt, string $stage, int $page = 1, int $pageSize = 200) {
        return self::getClass()->getActiveStageRecord([
            "createStartAt" => $createStartAt,
            "createEndAt" => $createEndAt,
            "stage" => $stage,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 通过时间筛选待看片订单
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  string $stage 状态 [ require true ]
     * @param  string $module 订单module [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getWaitLookingOrders (string $module, string $startAt, string $endAt, string $stage, int $page = 1, int $pageSize = 200) {
        return self::getClass()->getWaitLookingOrders([
            "module" => $module,
            "startAt" => $startAt,
            "endAt" => $endAt,
            "stage" => $stage,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 批量获取一批伙伴处理过的订单
     *
     * @support  array $staffIds 伙伴Id数组 [ require true ]
     * @support  array $storeIds 门店Id数组 [ require false ]
     * @support  bool $isFinished 是否完成 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffHandledOrders ($context) {
        return self::getClass()->getStaffHandledOrders([
            "context" => $context,
        ]);
    }

    /**
     * 获取新系统看片师工作量
     *
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @param  int $staffId 伙伴id [ require true ]
     * @param  string $orgType 机构类型 [ require true ]
     * @param  int $orgId 机构id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNewWorkload (string $startTime, string $endTime, int $staffId, string $orgType, int $orgId) {
        return self::getClass()->getNewWorkload([
            "startTime" => $startTime,
            "endTime" => $endTime,
            "staffId" => $staffId,
            "orgType" => $orgType,
            "orgId" => $orgId,
        ]);
    }

    /**
     * 通过看片师工号获取流水
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStreamBySecondRetoucher (int $staffId, string $startAt, string $endAt) {
        return self::getClass()->getStreamBySecondRetoucher([
            "staffId" => $staffId,
            "startAt" => $startAt,
            "endAt" => $endAt,
        ]);
    }

    /**
     * 通过订单ids获取看片预约时间
     *
     * @param  array $orderIds 订单id数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrdersEstimateTime (array $orderIds) {
        return self::getClass()->getOrdersEstimateTime([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 获取已完成看片的productIds
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCompleteLookPhotoProductIds (int $orderId) {
        return self::getClass()->getCompleteLookPhotoProductIds([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取服务过某订单的伙伴
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaperlessOrderServiceStaffs (int $orderId) {
        return self::getClass()->getPaperlessOrderServiceStaffs([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 无纸化订单列表
     *
     * @support  array $orderIds orderIds [ require false ]
     * @support  string $stage 无纸化订单阶段 [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  bool $isPrinted 是否打印 [ require false ]
     * @support  bool $isPosted 是否邮寄 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function paperlessOrderList ($context) {
        return self::getClass()->paperlessOrderList([
            "context" => $context,
        ]);
    }

    /**
     * 获取在线看片信息
     *
     * @param  array $orderIds orderIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPictureOnline (array $orderIds) {
        return self::getClass()->getPictureOnline([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Api\PaperlessOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Api\PaperlessOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}