<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method pushOrderToCameramanByParams(array $params)
 * @method revokeCloudStreamByParams(array $params)
 * @method getCloudStreamInfoByParams(array $params)
 * @method submitToCloudExtraByParams(array $params)
 * @method getHistoryInfoByParams(array $params)
 * @method revokeOrderByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 * @method getUploadTokenByParams(array $params)
 * @method createCloudProductByParams(array $params)
 * @method enableCloudProductByParams(array $params)
 * @method batchGetStreamInfoByIdsByParams(array $params)
 * @method getTotalCountByParams(array $params)
 * @method getExtraHistoryListByParams(array $params)
 * @method revokeSubmitExtraByParams(array $params)
 * @method reSubmitExtraByParams(array $params)
 * @method getExtraPhotoDetailByParams(array $params)
 * @method remainingPhotoByParams(array $params)
 * @method excellencePhotoUploadSettingByParams(array $params)
 * @method shanghaiBlueStoreByParams(array $params)
 * @method getOrderTakeTimeByParams(array $params)
 * @method getOrderCameramanInfoBaseAuthByParams(array $params)
 * @method getDresserNoteByOrderIdsByParams(array $params)
 */
class Cameraman {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单添加至摄影师
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function pushOrderToCameraman ($context, int $orderId) {
        return self::getClass()->pushOrderToCameraman([
            "context" => $context,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 撤回照片(流水维度)
     *
     * @param  int $cloudStreamId 流水id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function revokeCloudStream ($context, int $cloudStreamId) {
        return self::getClass()->revokeCloudStream([
            "context" => $context,
            "cloudStreamId" => $cloudStreamId,
        ]);
    }

    /**
     * 云端流水详情
     *
     * @param  int $cloudStreamId 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudStreamInfo (int $cloudStreamId) {
        return self::getClass()->getCloudStreamInfo([
            "cloudStreamId" => $cloudStreamId,
        ]);
    }

    /**
     * 多余底片上传
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $productId 产品id [ require true ]
     * @support  array $photos 照片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitToCloudExtra ($context) {
        return self::getClass()->submitToCloudExtra([
            "context" => $context,
        ]);
    }

    /**
     * 获取订单历史上传记录详情
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHistoryInfo (int $orderId) {
        return self::getClass()->getHistoryInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 撤回照片(订单维度)
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function revokeOrder ($context, int $orderId) {
        return self::getClass()->revokeOrder([
            "context" => $context,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取Host
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 获取上传签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUploadToken () {
        return self::getClass()->getUploadToken();
    }

    /**
     * 创建云端产品
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createCloudProduct (int $productId) {
        return self::getClass()->createCloudProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 启用云端产品
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableCloudProduct (int $productId) {
        return self::getClass()->enableCloudProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 批量获取流水详情(通过流水id)
     *
     * @support  array $cloudStreamIds 流水ids [ require false ]
     * @support  string $brand 品牌 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchGetStreamInfoByIds ($context) {
        return self::getClass()->batchGetStreamInfoByIds([
            "context" => $context,
        ]);
    }

    /**
     * 获取赠送底片记录统计
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 顾客姓名 [ require false ]
     * @support  string $userPhone 顾客手机号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTotalCount ($context) {
        return self::getClass()->getTotalCount([
            "context" => $context,
        ]);
    }

    /**
     * 获取摄影师赠送底片上传记录列表
     *
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 顾客姓名 [ require false ]
     * @support  string $userPhone 顾客手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getExtraHistoryList ($context) {
        return self::getClass()->getExtraHistoryList([
            "context" => $context,
        ]);
    }

    /**
     * 撤回赠送底片上传
     *
     * @support  int $id 赠送底片记录Id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function revokeSubmitExtra ($context) {
        return self::getClass()->revokeSubmitExtra([
            "context" => $context,
        ]);
    }

    /**
     * 重新上传多余底片
     *
     * @support  int $id 历史记录id [ require true ]
     * @support  array $photos 照片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reSubmitExtra ($context) {
        return self::getClass()->reSubmitExtra([
            "context" => $context,
        ]);
    }

    /**
     * 多余底片详情
     *
     * @support  int $id 历史记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getExtraPhotoDetail ($context) {
        return self::getClass()->getExtraPhotoDetail([
            "context" => $context,
        ]);
    }

    /**
     * 获取剩余传输底片数量
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remainingPhoto ($context) {
        return self::getClass()->remainingPhoto([
            "context" => $context,
        ]);
    }

    /**
     * 当前门店是否需要上传优秀底片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function excellencePhotoUploadSetting ($context) {
        return self::getClass()->excellencePhotoUploadSetting();
    }

    /**
     * 判断是否为上海蓝标店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function shanghaiBlueStore ($context) {
        return self::getClass()->shanghaiBlueStore();
    }

    /**
     * 获取订单取片时间
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderTakeTime (int $orderId) {
        return self::getClass()->getOrderTakeTime([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取订单绑定的摄影师信息及权限
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderCameramanInfoBaseAuth (int $orderId) {
        return self::getClass()->getOrderCameramanInfoBaseAuth([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 批量获取订单化妆备注
     *
     * @param  array $orderIds 订单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDresserNoteByOrderIds (array $orderIds) {
        return self::getClass()->getDresserNoteByOrderIds([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Cameraman');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Cameraman');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}