<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cancelHangByParams(array $params)
 * @method getStaffStatusByParams(array $params)
 * @method getNamesByStaffIdsByParams(array $params)
 * @method beginWorkByParams(array $params)
 * @method endWorkByParams(array $params)
 * @method getProcessingTimesByParams(array $params)
 * @method getStaffInfoByIdByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 取消挂起
     *
     * @support  int $staffId 伙伴id [ require false ]
     * @support  string $staffType 伙伴类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelHang ($context) {
        return self::getClass()->cancelHang([
            "context" => $context,
        ]);
    }

    /**
     * 获取伙伴的状态
     *
     * @support  int $staffId 伙伴id [ require false ]
     * @support  string $staffType 伙伴类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffStatus ($context) {
        return self::getClass()->getStaffStatus([
            "context" => $context,
        ]);
    }

    /**
     * 通过staffIds获取伙伴名字列表
     *
     * @support  array $staffIds 伙伴id列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNamesByStaffIds ($context) {
        return self::getClass()->getNamesByStaffIds([
            "context" => $context,
        ]);
    }

    /**
     * 开始工作
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function beginWork ($context) {
        return self::getClass()->beginWork();
    }

    /**
     * 结束工作
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function endWork ($context) {
        return self::getClass()->endWork();
    }

    /**
     * 门店工作信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProcessingTimes ($context) {
        return self::getClass()->getProcessingTimes();
    }

    /**
     * 根据伙伴id获取伙伴信息
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffInfoById (int $staffId) {
        return self::getClass()->getStaffInfoById([
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}