<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cloudPhotographyColorByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\CloudPhotographyColorDto $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取技术要点（拍摄底图）
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\CloudPhotographyColorDto $dto
     * @throws  \Exception
     * @return  array
     */
    public static function cloudPhotographyColor (\Mainto\Bridge\Structs\ProjectPaperless\Photoshop\Dto\CloudPhotographyColorDto $dto) {
        return self::getClass()->cloudPhotographyColor($dto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'User\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'User\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}