<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method launchDetailByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Order\AfterSale\Dto\LaunchDto $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Order\AfterSale\Dto\CreateAfterSaleDto $params)
 * @method terminateApplyByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Order\AfterSale\Dto\TerminateApplyDto $params)
 */
class OrderAfterSale {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取二次看片售后订单详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Order\AfterSale\Dto\LaunchDto $dto
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Order\AfterSale\Dto\LaunchResDto
     */
    public static function launchDetail (\Mainto\Bridge\Structs\ProjectPaperless\Order\AfterSale\Dto\LaunchDto $dto) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->launchDetail($dto),
            "\Mainto\Bridge\Structs\ProjectPaperless\Order\AfterSale\Dto\LaunchResDto"
        );
    }


    /**
     * 创建二次看片
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Order\AfterSale\Dto\CreateAfterSaleDto $dto
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (\Mainto\Bridge\Structs\ProjectPaperless\Order\AfterSale\Dto\CreateAfterSaleDto $dto) {
        return self::getClass()->create($dto);
    }


    /**
     * 取消售后单
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Order\AfterSale\Dto\TerminateApplyDto $dto
     * @throws  \Exception
     * @return  bool
     */
    public static function terminateApply (\Mainto\Bridge\Structs\ProjectPaperless\Order\AfterSale\Dto\TerminateApplyDto $dto) {
        return self::getClass()->terminateApply($dto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\OrderAfterSale');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\OrderAfterSale');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}