<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method assignSecondRetouchByParams(array $params)
 * @method changeSecondRetouchStoreByParams(array $params)
 * @method changeSecondReviewingByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\ChangeStore\DTO\ChangeStoreReviewingDto $params)
 * @method cancelChangeSecondRetouchStoreByParams(array $params)
 * @method getSecondRetouchChangeStoreOrderListByParams(array $params)
 * @method deleteByParams(array $params)
 * @method saveByParams(array $params)
 * @method findOneByOrderNumByParams(array $params)
 * @method findOneByOrderIdByParams(array $params)
 */
class ChangeStoreWatchPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 转门店看片指派【看片相关】
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  int $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function assignSecondRetouch ($context, string $orderNum, int $staffId) {
        return self::getClass()->assignSecondRetouch([
            "context" => $context,
            "orderNum" => $orderNum,
            "staffId" => $staffId,
        ]);
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  int $orderId 订单号 [ require true ]
     * @param  int $storeId 门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeSecondRetouchStore ($context, int $orderId, int $storeId = 0) {
        return self::getClass()->changeSecondRetouchStore([
            "context" => $context,
            "orderId" => $orderId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 转门店看片操作直接进入审核中
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\ChangeStore\DTO\ChangeStoreReviewingDto $changeStoreReviewingDto
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeSecondReviewing (\Mainto\Bridge\Structs\ProjectPaperless\ChangeStore\DTO\ChangeStoreReviewingDto $changeStoreReviewingDto) {
        return self::getClass()->changeSecondReviewing($changeStoreReviewingDto);
    }


    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $storeId 门店id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelChangeSecondRetouchStore ($context, int $orderId, int $storeId = 0) {
        return self::getClass()->cancelChangeSecondRetouchStore([
            "context" => $context,
            "orderId" => $orderId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取转门店订单列表
     *
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $userName 姓名 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSecondRetouchChangeStoreOrderList ($context) {
        return self::getClass()->getSecondRetouchChangeStoreOrderList([
            "context" => $context,
        ]);
    }

    /**
     * 删除看片转门店信息
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $storeId, string $orderNum) {
        return self::getClass()->delete([
            "storeId" => $storeId,
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 保存看片转门店信息
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function save (int $storeId, string $orderNum) {
        return self::getClass()->save([
            "storeId" => $storeId,
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 获取看片转门店信息
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function findOneByOrderNum (string $orderNum) {
        return self::getClass()->findOneByOrderNum([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * WARN: 被预约端(AppointmentPlatform) 调用
     *
     * @param  int $orderId 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function findOneByOrderId (int $orderId) {
        return self::getClass()->findOneByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\ChangeStoreWatchPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\ChangeStoreWatchPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}