<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cloudProductInfoByParams(array|\Mainto\Bridge\Structs\ProjectPaperless\Product\Dto\ProductInfoDto $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectPaperless\Product\Dto\ProductInfoDto $dto
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectPaperless\Product\Dto\ProductInfoResDto[]
     */
    public static function cloudProductInfo (\Mainto\Bridge\Structs\ProjectPaperless\Product\Dto\ProductInfoDto $dto) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->cloudProductInfo($dto),
            "\Mainto\Bridge\Structs\ProjectPaperless\Product\Dto\ProductInfoResDto[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}