<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getQueueInfoByParams(array $params)
 * @method clearOrderByParams(array $params)
 * @method debugByParams(array $params)
 * @method whyByParams(array $params)
 * @method getProductsInOrderByParams(array $params)
 * @method pingWebsocketByParams(array $params)
 * @method closeProcessByParams(array $params)
 * @method addProcessesByParams(array $params)
 * @method takeOrderDetailByParams(array $params)
 * @method refreshStaffStateByParams(array $params)
 * @method saveProcessByParams(array $params)
 * @method testFuncByParams(array $params)
 * @method sendXiuNotifyByParams(array $params)
 * @method fixHangOrderByParams(array $params)
 * @method newStagesByParams(array $params)
 * @method removeOrderStageNumsCacheByParams(array $params)
 * @method tabOrderProcessNotDealWithByParams(array $params)
 * @method failByParams(array $params)
 * @method fail2ByParams(array $params)
 * @method retakeProcessByParams(array $params)
 */
class Debug {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getQueueInfo
     *
     * @param  string $storeId storeId [ require true ]
     * @param  bool $refresh refresh [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQueueInfo (string $storeId, bool $refresh = false) {
        return self::getClass()->getQueueInfo([
            "storeId" => $storeId,
            "refresh" => $refresh,
        ]);
    }

    /**
     * 恢复到等待拍摄状态
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearOrder () {
        return self::getClass()->clearOrder();
    }

    /**
     * debug
     *
     * @support  string $orderNo orderNo require false
     * @support  string $orderId orderId require false
     * @support  string $staffId orderId require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function debug () {
        return self::getClass()->debug();
    }

    /**
     * why
     *
     * @param  uint $storeId storeId [ require true ]
     * @param  uint $staffId staffId [ require true ]
     * @param  string $staffType staffType [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function why (int $storeId, int $staffId, string $staffType) {
        return self::getClass()->why([
            "storeId" => $storeId,
            "staffId" => $staffId,
            "staffType" => $staffType,
        ]);
    }

    /**
     * getProductsInOrder
     *
     * @param  uint $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsInOrder (int $id) {
        return self::getClass()->getProductsInOrder([
            "id" => $id,
        ]);
    }

    /**
     * ping websocket
     *
     * @support  int $storeId 门店id require false
     * @support  int $staffId 伙伴id require false
     * @support  string $staffType 摄影师: sys,化妆师: hzs require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function pingWebsocket () {
        return self::getClass()->pingWebsocket();
    }

    /**
     * closeProcess
     *
     * @param  int $processId processId [ require true ]
     * @param  string $reason reason [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeProcess (int $processId, string $reason) {
        return self::getClass()->closeProcess([
            "processId" => $processId,
            "reason" => $reason,
        ]);
    }

    /**
     * addProcesses
     *
     * @param  int $orderId orderId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProcesses (int $orderId) {
        return self::getClass()->addProcesses([
            "orderId" => $orderId,
        ]);
    }

    /**
     * takeOrderDetail
     *
     * @param  string $key key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeOrderDetail (string $key) {
        return self::getClass()->takeOrderDetail([
            "key" => $key,
        ]);
    }

    /**
     * 伙伴状态恢复到等待
     *
     * @support  int $storeId 门店id require false
     * @support  int $staffId 伙伴id require false
     * @support  string $staffType 伙伴类型 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshStaffState () {
        return self::getClass()->refreshStaffState();
    }

    /**
     * saveProcess
     *
     * @support  string $token token [ require true ]
     * @support  int $staffId staffId [ require true ]
     * @support  string $staffType staffType [ require true ]
     * @support  int $processId processId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveProcess () {
        return self::getClass()->saveProcess();
    }

    /**
     * testFunc
     *
     * @support  int $staffId staffId [ require true ]
     * @support  int $storeId storeId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function testFunc () {
        return self::getClass()->testFunc();
    }

    /**
     * 摄影师底片推送
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendXiuNotify () {
        return self::getClass()->sendXiuNotify();
    }

    /**
     * fixHangOrder
     *
     * @support  string $orderIds 订单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixHangOrder () {
        return self::getClass()->fixHangOrder();
    }

    /**
     * newStages
     *
     * @support  string $processIds processIds [ require true ]
     * @support  string $stage stage require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function newStages () {
        return self::getClass()->newStages();
    }

    /**
     * 清除门店无纸化订单数的缓存
     *
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function removeOrderStageNumsCache (array $storeIds) {
        return self::getClass()->removeOrderStageNumsCache([
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 标记订单process没有上传流水为无需上传
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function tabOrderProcessNotDealWith (int $orderId) {
        return self::getClass()->tabOrderProcessNotDealWith([
            "orderId" => $orderId,
        ]);
    }

    /**
     * fail
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function fail () {
        return self::getClass()->fail();
    }

    /**
     * fail2
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function fail2 () {
        return self::getClass()->fail2();
    }

    /**
     * retakeProcess
     *
     * @support  array $processIds processIds [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function retakeProcess () {
        return self::getClass()->retakeProcess();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Debug');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Debug');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}