<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queueToWaitingByParams(array $params)
 * @method removeStaffHangByParams(array $params)
 * @method dailyCleanByParams(array $params)
 * @method dingUsersWhenOrderHangingTimeOutByParams(array $params)
 * @method cronSendXiuNotifyByParams(array $params)
 * @method cronCheckAndRemoveUnReviewOrderByParams(array $params)
 * @method cronClearExpiredReservationByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天9-23点每分钟执行-签到排队状态自动进入等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queueToWaiting () {
        return self::getClass()->queueToWaiting();
    }

    /**
     * 每天9-23点每分钟执行-对超过1小时挂起的伙伴解除挂起
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStaffHang () {
        return self::getClass()->removeStaffHang();
    }

    /**
     * 每天4点执行-清空前一日流程记录
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function dailyClean () {
        return self::getClass()->dailyClean();
    }

    /**
     * 签到排队状态自动进入化妆等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function dingUsersWhenOrderHangingTimeOut () {
        return self::getClass()->dingUsersWhenOrderHangingTimeOut();
    }

    /**
     * cronSendXiuNotify
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronSendXiuNotify () {
        return self::getClass()->cronSendXiuNotify();
    }

    /**
     * (定时任务:)修改未审核完成的流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronCheckAndRemoveUnReviewOrder () {
        return self::getClass()->cronCheckAndRemoveUnReviewOrder();
    }

    /**
     * 定时清理过号
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronClearExpiredReservation () {
        return self::getClass()->cronClearExpiredReservation();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}