<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method setPrintByParams(array $params)
 * @method detailByParams(array $params)
 * @method changeTakePhotoTypeByParams(array $params)
 * @method addPostNumByParams(array $params)
 * @method hookUserTakePhotoByParams(array $params)
 * @method checkConformOnlineOrderByParams(array $params)
 * @method batchCheckConformOnlineOrderByParams(array $params)
 */
class PictureOnline {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取在线看片列表
     *
     * @support  int $page 页码 [Original type uint] 
     * @support  int $pageSize 每页条数 [Original type uint] 
     * @support  string $isPrinted 是否打印 
     * @support  string $isPosted 是否邮寄 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 在线看片设置打印
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPrint (string $recordNo) {
        return self::getClass()->setPrint([
            "recordNo" => $recordNo,
        ]);
    }

    /**
     * 在线看片详情
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (string $orderNum) {
        return self::getClass()->detail([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 修改取片方式
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  string $takeType 取片方式 [ require true ]
     * @param  array $postInfo 取片信息 [ require true ]
     * @support  string $postInfo.province 省 
     * @support  string $postInfo.city 市 
     * @support  string $postInfo.area 区 
     * @support  string $postInfo.detail 详细地址 
     * @support  string $postInfo.name 名字 
     * @support  string $postInfo.phone 电话 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeTakePhotoType (string $recordNo, string $takeType = NULL, array $postInfo = []) {
        return self::getClass()->changeTakePhotoType([
            "recordNo" => $recordNo,
            "takeType" => $takeType,
            "postInfo" => $postInfo,
        ]);
    }

    /**
     * 标记发件
     *
     * @param  string $recordNo 看片单号 [ require true ]
     * @param  string $postNum 邮递单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPostNum (string $recordNo, string $postNum) {
        return self::getClass()->addPostNum([
            "recordNo" => $recordNo,
            "postNum" => $postNum,
        ]);
    }

    /**
     * todo 邮寄信息提醒伙伴
     *
     * @param  string $outsideNo 订单号 [ require true ]
     * @param  int $orgId 机构id [Original type uint] [ require true ]
     * @param  array $takeType 取片方式 [ require true ]
     * @param  int $photoCount 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookUserTakePhoto (string $outsideNo, int $orgId, array $takeType, int $photoCount) {
        return self::getClass()->hookUserTakePhoto([
            "outsideNo" => $outsideNo,
            "orgId" => $orgId,
            "takeType" => $takeType,
            "photoCount" => $photoCount,
        ]);
    }

    /**
     * 订单是否符合在线看片
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $storeId 门店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkConformOnlineOrder (string $orderNo, int $storeId) {
        return self::getClass()->checkConformOnlineOrder([
            "orderNo" => $orderNo,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 批量获取订单是否符合在线看片
     *
     * @param  array $orderInfo 订单信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCheckConformOnlineOrder (array $orderInfo) {
        return self::getClass()->batchCheckConformOnlineOrder([
            "orderInfo" => $orderInfo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\PictureOnline');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\PictureOnline');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}