<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method paperlessOrdersByParams(array $params)
 * @method saveNoteByParams(array $params)
 * @method getOrderStageNumsByParams(array $params)
 * @method assignStageStaffByParams(array $params)
 * @method cancelAssignStageStaffByParams(array $params)
 * @method hangByParams(array $params)
 * @method cancelHangByParams(array $params)
 * @method changeStaffByParams(array $params)
 * @method updateSortByParams(array $params)
 * @method getCanTakeOrderStaffIdsByParams(array $params)
 * @method backWaitPhotographyByParams(array $params)
 * @method backWaitMakeUpByParams(array $params)
 * @method backWaitLookPhotoByParams(array $params)
 * @method hasOffProductsByParams(array $params)
 * @method getStageStaffsByParams(array $params)
 * @method updateClothsByParams(array $params)
 * @method recoverByParams(array $params)
 * @method bigOrderByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表
     *
     * @support  string $userPhone 手机号 
     * @support  string $userName 姓名 
     * @support  string $orderNo 订单号 
     * @support  string $status 订单状态 
     * @support  int $storeId 门店id [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 无纸化订单列表
     *
     * @support  string $userPhone 手机号 
     * @support  string $userName 姓名 
     * @support  string $orderNo 订单号 
     * @support  string $stage 流程状态 
     * @support  int $storeId 门店id [ require true ]
     * @support  bool $isPrinted 是否打印 
     * @support  bool $isPosted 是否邮寄 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function paperlessOrders () {
        return self::getClass()->paperlessOrders();
    }

    /**
     * 更新订单备注信息
     *
     * @support  int $orderId 订单id 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveNote () {
        return self::getClass()->saveNote();
    }

    /**
     * 更新流程备注信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderStageNums () {
        return self::getClass()->getOrderStageNums();
    }

    /**
     * 指定订单接单伙伴
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $staffId 伙伴id [ require true ]
     * @support  string $stage 阶段 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function assignStageStaff () {
        return self::getClass()->assignStageStaff();
    }

    /**
     * 清除订单接单伙伴
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $stage 阶段 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelAssignStageStaff () {
        return self::getClass()->cancelAssignStageStaff();
    }

    /**
     * 挂起订单
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hang () {
        return self::getClass()->hang();
    }

    /**
     * 取消挂起订单
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelHang () {
        return self::getClass()->cancelHang();
    }

    /**
     * 更换伙伴
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStaff () {
        return self::getClass()->changeStaff();
    }

    /**
     * 更新接单顺序
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $sort 排序值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateSort () {
        return self::getClass()->updateSort();
    }

    /**
     * 获取订单可接单伙伴ids
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCanTakeOrderStaffIds () {
        return self::getClass()->getCanTakeOrderStaffIds();
    }

    /**
     * 退回至等待摄影
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function backWaitPhotography () {
        return self::getClass()->backWaitPhotography();
    }

    /**
     * 退回至等待化妆
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function backWaitMakeUp () {
        return self::getClass()->backWaitMakeUp();
    }

    /**
     * 退回至等待看片
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function backWaitLookPhoto () {
        return self::getClass()->backWaitLookPhoto();
    }

    /**
     * 订单中是否存在已下架产品
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hasOffProducts () {
        return self::getClass()->hasOffProducts();
    }

    /**
     * 获取订单的伙伴列表
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStageStaffs () {
        return self::getClass()->getStageStaffs();
    }

    /**
     * 更改服装
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  array $items 更改信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateCloths () {
        return self::getClass()->updateCloths();
    }

    /**
     * 恢复到等待拍摄状态
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recover () {
        return self::getClass()->recover();
    }

    /**
     * 是否是大订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bigOrder (int $orderId) {
        return self::getClass()->bigOrder([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}