<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getClothsByParams(array $params)
 * @method continueToMakeUpByParams(array $params)
 * @method completeMakeUpByParams(array $params)
 * @method completePhotographyByParams(array $params)
 * @method completeAndHangByParams(array $params)
 * @method goSelectPhotoByParams(array $params)
 * @method assignAssistanceByParams(array $params)
 * @method orderAgainByParams(array $params)
 * @method takeOrderByParams(array $params)
 * @method saveNoteByParams(array $params)
 */
class Process {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店产品可选衣服
     *
     * @support  int $processId 流程id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCloths () {
        return self::getClass()->getCloths();
    }

    /**
     * 主化妆师继续化妆
     *
     * @support  int $processId 流程id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function continueToMakeUp () {
        return self::getClass()->continueToMakeUp();
    }

    /**
     * 完成化妆
     *
     * @support  int $processId 流程id [Original type uint] [ require true ]
     * @support  array $item 交换产品信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeMakeUp () {
        return self::getClass()->completeMakeUp();
    }

    /**
     * 完成摄影
     *
     * @support  int $processId 流程id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function completePhotography () {
        return self::getClass()->completePhotography();
    }

    /**
     * 完成并挂起
     *
     * @support  int $processId 流程id [Original type uint] 
     * @support  array $item 交换产品信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeAndHang () {
        return self::getClass()->completeAndHang();
    }

    /**
     * 完成摄影去选片
     *
     * @support  int $processId 流程id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function goSelectPhoto () {
        return self::getClass()->goSelectPhoto();
    }

    /**
     * 指派协作化妆师
     *
     * @support  int $processId 流程id [ require true ]
     * @support  array $items 协作伙伴 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function assignAssistance () {
        return self::getClass()->assignAssistance();
    }

    /**
     * 再来一单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderAgain () {
        return self::getClass()->orderAgain();
    }

    /**
     * 接新订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeOrder () {
        return self::getClass()->takeOrder();
    }

    /**
     * 更新流程备注信息
     *
     * @support  int $processId 流程id [Original type uint] 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveNote () {
        return self::getClass()->saveNote();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'User\Process');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'User\Process');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}