<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method saveNoteByParams(array $params)
 * @method getWaitingCountByParams(array $params)
 * @method duringWorkByParams(array $params)
 * @method updateClothsByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单详情
     *
     * @support  int $orderId 订单id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 更新订单备注信息
     *
     * @support  int $orderId 订单id require false
     * @support  string $note 备注 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveNote () {
        return self::getClass()->saveNote();
    }

    /**
     * 获取等待数量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWaitingCount () {
        return self::getClass()->getWaitingCount();
    }

    /**
     * 获取用时明细
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function duringWork () {
        return self::getClass()->duringWork();
    }

    /**
     * 更改服装
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  array $items 更改信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateCloths () {
        return self::getClass()->updateCloths();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'User\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'User\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}