<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method assignSecondRetouchByParams(array $params)
 * @method changeSecondRetouchStoreByParams(array $params)
 * @method cancelChangeSecondRetouchStoreByParams(array $params)
 * @method getSecondRetouchChangeStoreOrderListByParams(array $params)
 */
class ChangeStoreWatchPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 转门店看片指派【看片】
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  int $staffId 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function assignSecondRetouch (string $orderNum, int $staffId) {
        return self::getClass()->assignSecondRetouch([
            "orderNum" => $orderNum,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 转门店操作
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeSecondRetouchStore (string $orderNum) {
        return self::getClass()->changeSecondRetouchStore([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 取消转门店操作
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelChangeSecondRetouchStore (string $orderNum) {
        return self::getClass()->cancelChangeSecondRetouchStore([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 获取转门店订单列表
     *
     * @support  string $orderNum 订单号 
     * @support  string $userName 姓名 
     * @support  string $userPhone 手机号 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getSecondRetouchChangeStoreOrderList () {
        return self::getClass()->getSecondRetouchChangeStoreOrderList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\ChangeStoreWatchPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\ChangeStoreWatchPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}