<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPaperlessOrderByParams(array $params)
 * @method getPaperlessOrderByOrderIdsByParams(array $params)
 * @method getActiveStageRecordByParams(array $params)
 */
class PaperlessOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getPaperlessOrder
     *
     * @param  int $orderId orderId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaperlessOrder (int $orderId) {
        return self::getClass()->getPaperlessOrder([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getPaperlessOrderByOrderIds
     *
     * @param  array $orderIds orderIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaperlessOrderByOrderIds (array $orderIds) {
        return self::getClass()->getPaperlessOrderByOrderIds([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 获取某个进行中阶段的数据
     *
     * @param  string $createStartAt 开始时间 [ require true ]
     * @param  string $createEndAt 结束时间 [ require true ]
     * @param  string $stage 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActiveStageRecord (string $createStartAt, string $createEndAt, string $stage) {
        return self::getClass()->getActiveStageRecord([
            "createStartAt" => $createStartAt,
            "createEndAt" => $createEndAt,
            "stage" => $stage,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Api\PaperlessOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Api\PaperlessOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}