<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getQueueInfoByParams(array $params)
 * @method whyByParams(array $params)
 * @method redisCmdByParams(array $params)
 */
class Debug {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getQueueInfo
     *
     * @param  string $storeId storeId [ require true ]
     * @param  bool $refresh refresh [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getQueueInfo (string $storeId, bool $refresh = false) {
        return self::getClass()->getQueueInfo([
            "storeId" => $storeId,
            "refresh" => $refresh,
        ]);
    }

    /**
     * why
     *
     * @param  int $storeId storeId [Original type uint] [ require true ]
     * @param  int $staffId staffId [Original type uint] [ require true ]
     * @param  string $staffType staffType [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function why (int $storeId, int $staffId, string $staffType) {
        return self::getClass()->why([
            "storeId" => $storeId,
            "staffId" => $staffId,
            "staffType" => $staffType,
        ]);
    }

    /**
     * 查询 redis 数据 - 临时查看dev的数据
     *
     * @support  string $token token [ require true ]
     * @support  string $cmd cmd [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function redisCmd () {
        return self::getClass()->redisCmd();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Debug');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Debug');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}