<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPaperlessOrderByParams(array $params)
 * @method getPaperlessOrderByOrderIdsByParams(array $params)
 * @method getActiveStageRecordByParams(array $params)
 * @method getStaffHandledOrdersByParams(array $params)
 * @method getNewWorkloadByParams(array $params)
 * @method getStreamBySecondRetoucherByParams(array $params)
 */
class PaperlessOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 无纸化订单信息
     *
     * @param  int $orderId orderId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaperlessOrder (int $orderId) {
        return self::getClass()->getPaperlessOrder([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 批量获取无纸化订单信息
     *
     * @param  array $orderIds orderIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaperlessOrderByOrderIds (array $orderIds) {
        return self::getClass()->getPaperlessOrderByOrderIds([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 获取某个进行中阶段的数据
     *
     * @param  string $createStartAt 开始时间 [ require true ]
     * @param  string $createEndAt 结束时间 [ require true ]
     * @param  string $stage 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getActiveStageRecord (string $createStartAt, string $createEndAt, string $stage) {
        return self::getClass()->getActiveStageRecord([
            "createStartAt" => $createStartAt,
            "createEndAt" => $createEndAt,
            "stage" => $stage,
        ]);
    }

    /**
     * TODO;
     *
     * @support  array $staffIds 伙伴Id数组 [ require true ]
     * @support  array $storeIds 门店Id数组 
     * @support  bool $isFinished 是否完成 
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffHandledOrders () {
        return self::getClass()->getStaffHandledOrders();
    }

    /**
     * 获取新系统看片师工作量
     *
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @param  int $staffId 伙伴id [ require true ]
     * @param  string $orgType 机构类型 [ require true ]
     * @param  int $orgId 机构id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getNewWorkload (string $startTime, string $endTime, int $staffId, string $orgType, int $orgId) {
        return self::getClass()->getNewWorkload([
            "startTime" => $startTime,
            "endTime" => $endTime,
            "staffId" => $staffId,
            "orgType" => $orgType,
            "orgId" => $orgId,
        ]);
    }

    /**
     * 通过看片师工号获取流水
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamBySecondRetoucher (int $staffId, string $startAt, string $endAt) {
        return self::getClass()->getStreamBySecondRetoucher([
            "staffId" => $staffId,
            "startAt" => $startAt,
            "endAt" => $endAt,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Api\PaperlessOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Api\PaperlessOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}