<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method delaySendNoticeBySelectPhotoTimeout15MinuteByParams(array $params)
 * @method delaySendNoticeBySelectPhotoTimeout30MinuteByParams(array $params)
 * @method changeSalesByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method refundOrderByParams(array $params)
 * @method partRefundOrderByParams(array $params)
 * @method upgradeSkuByParams(array $params)
 * @method syncPassProductIdsByParams(array $params)
 * @method hookPictureOrderChangeToStoreByParams(array $params)
 * @method hookPictureOrderTagDissatisfiedByParams(array $params)
 * @method orderRetakeSaleSkuByParams(array $params)
 * @method retakeOrderCancelNotifyByParams(array $params)
 */
class MessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 选片超时15分钟通知
     *
     * @support  int $processId 流程Id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function delaySendNoticeBySelectPhotoTimeout15Minute () {
        return self::getClass()->delaySendNoticeBySelectPhotoTimeout15Minute();
    }

    /**
     * 选片超时30分钟通知
     *
     * @support  int $process_id 流程Id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function delaySendNoticeBySelectPhotoTimeout30Minute () {
        return self::getClass()->delaySendNoticeBySelectPhotoTimeout30Minute();
    }

    /**
     * 订单修改拍摄产品通知
     *
     * @support  int $orderId 订单Id 
     * @support  int $storeId 门店Id 
     * @support  array $removeSaleList 删除列表 
     * @support  array $createSaleList 创建列表 
     * @support  array $modifySaleList 修改列表 
     * @support  array $replaceSaleList 替换原产品列表 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeSales () {
        return self::getClass()->changeSales();
    }

    /**
     * 关闭订单流程
     *
     * @support  int $orderId 订单Id 
     * @support  int $storeId 门店Id 
     * @support  string $changeReserveTime 预约时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder () {
        return self::getClass()->closeOrder();
    }

    /**
     * 退回到等待拍摄流程
     *
     * @support  int $id 订单Id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function recoverWaitShooting () {
        return self::getClass()->recoverWaitShooting();
    }

    /**
     * 订单退款通知
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  int $storeId 门店Id [ require true ]
     * @support  array $closedSaleIds 退款sale_id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundOrder () {
        return self::getClass()->refundOrder();
    }

    /**
     * partRefundOrder
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  int $storeId 门店Id [ require true ]
     * @support  array $orderSkuList 退款后skuList 
     * @throws  \Exception
     * @return  string
     */
    public static function partRefundOrder () {
        return self::getClass()->partRefundOrder();
    }

    /**
     * 订单完成之后的加修加印推送
     *
     * @support  int $orderId 订单Id 
     * @support  int $storeId 门店Id 
     * @support  array $upgradeSkuList 升级服务列表 
     * @throws  \Exception
     * @return  mixed
     */
    public static function upgradeSku () {
        return self::getClass()->upgradeSku();
    }

    /**
     * 更新通关产品ids
     *
     * @support  int $staffId 伙伴id 
     * @support  array $productIds 通关产品ids 
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncPassProductIds () {
        return self::getClass()->syncPassProductIds();
    }

    /**
     * hookPictureOrderChangeToStore
     *
     * @support  int $retoucher_no 修片师 [Original type uint] [ require true ]
     * @support  string $customer_name 顾客名 [ require true ]
     * @support  string $order_no 订单号 [ require true ]
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPictureOrderChangeToStore () {
        return self::getClass()->hookPictureOrderChangeToStore();
    }

    /**
     * hookPictureOrderTagDissatisfied
     *
     * @support  int $retoucher_no 修片师 [Original type uint] [ require true ]
     * @support  string $customer_name 顾客名 [ require true ]
     * @support  string $order_no 订单号 [ require true ]
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPictureOrderTagDissatisfied () {
        return self::getClass()->hookPictureOrderTagDissatisfied();
    }

    /**
     * orderRetakeSaleSku
     *
     * @support  int $orderId 订单id [Original type uint] [ require true ]
     * @support  int $storeId 门店id [Original type uint] [ require true ]
     * @support  int $retakeNewStoreId 重拍之后新门店id [Original type uint] 
     * @support  int $retakeNewOrderId 重拍之后新建的订单id [Original type uint] 
     * @support  array $retakeOrderSakeSku 重拍的拍摄产品 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderRetakeSaleSku () {
        return self::getClass()->orderRetakeSaleSku();
    }

    /**
     * 重拍订单超时关闭通知
     *
     * @support  int $afterOrderId 重拍后新建订单的订单Id [Original type uint] [ require true ]
     * @support  int $afterStoreId 重拍后新建订单的门店Id [Original type uint] [ require true ]
     * @support  string $cancelType 取消类型，auto：系统操作(超时)，hand：手动操作 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function retakeOrderCancelNotify () {
        return self::getClass()->retakeOrderCancelNotify();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'MessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'MessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}