<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getQueueInfoByParams(array $params)
 * @method clearOrderByParams(array $params)
 * @method whyByParams(array $params)
 * @method redisCmdByParams(array $params)
 * @method getProductsInOrderByParams(array $params)
 * @method pingWebsocketByParams(array $params)
 * @method addProcessesByParams(array $params)
 * @method findOrderByParams(array $params)
 * @method takeOrderDetailByParams(array $params)
 * @method refreshStaffStateByParams(array $params)
 * @method changeOrderStageByParams(array $params)
 * @method sendXiuNotifyByParams(array $params)
 */
class Debug {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getQueueInfo
     *
     * @param  string $storeId storeId [ require true ]
     * @param  bool $refresh refresh [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getQueueInfo (string $storeId, bool $refresh = false) {
        return self::getClass()->getQueueInfo([
            "storeId" => $storeId,
            "refresh" => $refresh,
        ]);
    }

    /**
     * 恢复到等待拍摄状态
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearOrder () {
        return self::getClass()->clearOrder();
    }

    /**
     * why
     *
     * @param  int $storeId storeId [Original type uint] [ require true ]
     * @param  int $staffId staffId [Original type uint] [ require true ]
     * @param  string $staffType staffType [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function why (int $storeId, int $staffId, string $staffType) {
        return self::getClass()->why([
            "storeId" => $storeId,
            "staffId" => $staffId,
            "staffType" => $staffType,
        ]);
    }

    /**
     * 查询 redis 数据 - 临时查看dev的数据
     *
     * @support  string $token token [ require true ]
     * @support  string $cmd cmd [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function redisCmd () {
        return self::getClass()->redisCmd();
    }

    /**
     * getProductsInOrder
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsInOrder (int $id) {
        return self::getClass()->getProductsInOrder([
            "id" => $id,
        ]);
    }

    /**
     * ping websocket
     *
     * @support  int $storeId 门店id 
     * @support  int $staffId 伙伴id 
     * @support  string $staffType 摄影师: sys,化妆师: hzs 
     * @throws  \Exception
     * @return  mixed
     */
    public static function pingWebsocket () {
        return self::getClass()->pingWebsocket();
    }

    /**
     * addProcesses
     *
     * @param  int $orderId orderId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProcesses (int $orderId) {
        return self::getClass()->addProcesses([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 查询订单信息
     *
     * @support  string $token token [ require true ]
     * @support  string $orderNo 订单号 
     * @support  int $orderId 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function findOrder () {
        return self::getClass()->findOrder();
    }

    /**
     * takeOrderDetail
     *
     * @param  string $key key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeOrderDetail (string $key) {
        return self::getClass()->takeOrderDetail([
            "key" => $key,
        ]);
    }

    /**
     * 伙伴状态恢复到等待
     *
     * @support  int $storeId 门店id 
     * @support  int $staffId 伙伴id 
     * @support  string $staffType 伙伴类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshStaffState () {
        return self::getClass()->refreshStaffState();
    }

    /**
     * 修改订单状态
     *
     * @support  string $token token [ require true ]
     * @support  int $orderId 订单id [ require true ]
     * @support  string $stage 阶段 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderStage () {
        return self::getClass()->changeOrderStage();
    }

    /**
     * 摄影师底片推送
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendXiuNotify () {
        return self::getClass()->sendXiuNotify();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Debug');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Debug');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}