<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getWaitReviewCountByParams(array $params)
 * @method cancelChangeSecondRetouchStoreByParams(array $params)
 * @method getWaitReviewListByParams(array $params)
 * @method queryWaitFinishListByParams(array $params)
 * @method getMyReviewListByParams(array $params)
 * @method reviewByParams(array $params)
 * @method getUnreadCountByParams(array $params)
 * @method checkUnreadStreamByParams(array $params)
 * @method lostOrderNotifyByParams(array $params)
 * @method cleanNotifyByParams(array $params)
 * @method getPictureOnlineRetoucherByParams(array $params)
 * @method reviewHistoryByParams(array $params)
 * @method getReviewDetailByParams(array $params)
 * @method getStoreOrdersByParams(array $params)
 * @method sendWatchPhotoNotifyByParams(array $params)
 * @method reworkStreamByParams(array $params)
 * @method getOrderOnlineByParams(array $params)
 * @method kpsOrderAgainByParams(array $params)
 * @method bindCheckerByParams(array $params)
 * @method historyByParams(array $params)
 * @method sendNoticeByParams(array $params)
 * @method getStreamStatusByParams(array $params)
 * @method getTemplatesByProductIdsByParams(array $params)
 * @method submitFinalPhotoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method hookCloudFinishStreamByParams(array $params)
 * @method hookCloudDeleteStreamByParams(array $params)
 * @method hookPictureOnlineTakeOrderByParams(array $params)
 * @method hookPictureOnlineCompleteOrderByParams(array $params)
 * @method hookHimoSetWorkloadsByParams(array $params)
 * @method cancelAuthByParams(array $params)
 */
class Retouch {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店待审核数【本门店＋转门店】
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getWaitReviewCount () {
        return self::getClass()->getWaitReviewCount();
    }

    /**
     * 取消转门店操作
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelChangeSecondRetouchStore (string $orderNum) {
        return self::getClass()->cancelChangeSecondRetouchStore([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 待审核订单列表
     *
     * @support  string $orderNum 订单号 
     * @support  string $userName 姓名 
     * @support  string $userPhone 手机号 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getWaitReviewList () {
        return self::getClass()->getWaitReviewList();
    }

    /**
     * 查询全国待完成订单列表[初始为查询转至本门店订单]
     *
     * @support  string $orderNum 订单号 
     * @support  string $userName 姓名 
     * @support  string $userPhone 手机号 
     * @support  string $brand 品牌 
     * @support  string $wholeOrderNum 全国范围订单号 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function queryWaitFinishList () {
        return self::getClass()->queryWaitFinishList();
    }

    /**
     * 我的审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMyReviewList () {
        return self::getClass()->getMyReviewList();
    }

    /**
     * 提交审核
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @support  string $evaluate 评价 
     * @support  array $photo 照片 
     * @support  string $note 评语 
     * @throws  \Exception
     * @return  mixed
     */
    public static function review () {
        return self::getClass()->review();
    }

    /**
     * 获取未读流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUnreadCount () {
        return self::getClass()->getUnreadCount();
    }

    /**
     * 查看未读流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkUnreadStream () {
        return self::getClass()->checkUnreadStream();
    }

    /**
     * 提示用户有未完成的订单审核
     *
     * @throws  \Exception
     * @return  array
     */
    public static function lostOrderNotify () {
        return self::getClass()->lostOrderNotify();
    }

    /**
     * 清除未完成的订单列表提示
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cleanNotify () {
        return self::getClass()->cleanNotify();
    }

    /**
     * 获取在线看片师信息
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPictureOnlineRetoucher (int $staffId) {
        return self::getClass()->getPictureOnlineRetoucher([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 看片审核历史列表
     *
     * @support  string $order_num 订单号 
     * @support  string $user_phone 手机号 
     * @support  string $user_name 姓名 
     * @support  string $brand 品牌 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @support  bool $search_without_staff 不根据伙伴查询 
     * @support  bool $changed_store 是否为转门店数据 
     * @throws  \Exception
     * @return  array
     */
    public static function reviewHistory () {
        return self::getClass()->reviewHistory();
    }

    /**
     * 看片审核详情
     *
     * @support  string $order_num 订单号 
     * @throws  \Exception
     * @return  array
     */
    public static function getReviewDetail () {
        return self::getClass()->getReviewDetail();
    }

    /**
     * 门店看片列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreOrders () {
        return self::getClass()->getStoreOrders();
    }

    /**
     * 发送看片通知
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWatchPhotoNotify () {
        return self::getClass()->sendWatchPhotoNotify();
    }

    /**
     * 看片退单
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  array $photoData 照片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reworkStream (string $streamNum, array $photoData) {
        return self::getClass()->reworkStream([
            "streamNum" => $streamNum,
            "photoData" => $photoData,
        ]);
    }

    /**
     * 看片师已接订单[取多单]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOnline () {
        return self::getClass()->getOrderOnline();
    }

    /**
     * 看片师再来一单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function kpsOrderAgain () {
        return self::getClass()->kpsOrderAgain();
    }

    /**
     * 绑定审核人id
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindChecker () {
        return self::getClass()->bindChecker();
    }

    /**
     * 获取看片师历史上传记录列表
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $orderNum 订单号 
     * @support  string $userName 顾客姓名 
     * @support  string $userPhone 顾客手机号 
     * @support  bool $searchWithoutStaff 不根据伙伴查询 
     * @support  bool $changedStore 是否为转门店数据 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function history () {
        return self::getClass()->history();
    }

    /**
     * 发送授权确认推送
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function sendNotice () {
        return self::getClass()->sendNotice();
    }

    /**
     * 获取流水状态
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamStatus () {
        return self::getClass()->getStreamStatus();
    }

    /**
     * 获取产品贴图模板
     *
     * @param  array $productIds 产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTemplatesByProductIds (array $productIds) {
        return self::getClass()->getTemplatesByProductIds([
            "productIds" => $productIds,
        ]);
    }

    /**
     * 提交最终成片
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @param  array $photoData 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitFinalPhoto (string $streamNum, array $photoData) {
        return self::getClass()->submitFinalPhoto([
            "streamNum" => $streamNum,
            "photoData" => $photoData,
        ]);
    }

    /**
     * 获取看片师历史上传记录列表
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $orderNum 订单号 
     * @support  string $userName 顾客姓名 
     * @support  string $userPhone 顾客手机号 
     * @support  bool $searchWithoutStaff 不根据伙伴查询 
     * @support  bool $changedStore 是否为转门店数据 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList();
    }

    /**
     * 接收云端流水完成事件
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudFinishStream (string $stream_num) {
        return self::getClass()->hookCloudFinishStream([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * 接收云端流水删除事件
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudDeleteStream (string $stream_num) {
        return self::getClass()->hookCloudDeleteStream([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * 接收在线看片接单事件
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @support  string $streamNum streamNum [ require true ]
     * @param  string $retoucherNo 看片师工号 [ require true ]
     * @param  int $retoucherStore 看片师store [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPictureOnlineTakeOrder (string $orderNo, string $retoucherNo, int $retoucherStore) {
        return self::getClass()->hookPictureOnlineTakeOrder([
            "orderNo" => $orderNo,
            "retoucherNo" => $retoucherNo,
            "retoucherStore" => $retoucherStore,
        ]);
    }

    /**
     * 接收在线看片完成事件
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPictureOnlineCompleteOrder (string $orderNo) {
        return self::getClass()->hookPictureOnlineCompleteOrder([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 接收录工作量事件
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  array $workloads 工作量数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookHimoSetWorkloads (int $orderId, array $workloads) {
        return self::getClass()->hookHimoSetWorkloads([
            "orderId" => $orderId,
            "workloads" => $workloads,
        ]);
    }

    /**
     * 取消授权
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelAuth () {
        return self::getClass()->cancelAuth();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Retouch');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Retouch');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}