<?php
namespace Mainto\Bridge\Invokes\ProjectPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userSignInByParams(array $params)
 * @method retouchSignInByParams(array $params)
 */
class Process {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 前台签到
     *
     * @support  int $staffId 员工id 
     * @support  int $orderId 订单id [ require true ]
     * @support  int $dresserId 指定的化妆师id 
     * @support  int $cameramanId 指定的摄影师id 
     * @support  bool $skipMakeUp 是否跳过化妆 
     * @support  int $groupId 分组id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function userSignIn () {
        return self::getClass()->userSignIn();
    }

    /**
     * 看片签到
     *
     * @support  int $staffId 员工id 
     * @support  int $orderId 订单id [ require true ]
     * @support  int $retoucherId 指定的看片师id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function retouchSignIn () {
        return self::getClass()->retouchSignIn();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperless', 'Manage\Process');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperless', 'Manage\Process');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}