<?php
namespace Mainto\Bridge\Invokes\ProjectPaperlessV2\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderStreamsByParams(array $params)
 * @method getSteamsByIdsByParams(array $params)
 * @method getOrderDresserNoteByParams(array $params)
 */
class CloudStream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过orderNum获取云端流水
     *
     * @param  uint $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderStreams (int $orderId) {
        return self::getClass()->getOrderStreams([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 通过流水ids获取云端流水
     *
     * @param  array $streamIds 流水id数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSteamsByIds (array $streamIds) {
        return self::getClass()->getSteamsByIds([
            "streamIds" => $streamIds,
        ]);
    }

    /**
     * 通过streamNum获取订单备注信息
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderDresserNote (string $streamNum) {
        return self::getClass()->getOrderDresserNote([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperlessV2', 'Api\CloudStream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperlessV2', 'Api\CloudStream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}