<?php
namespace Mainto\Bridge\Invokes\ProjectPaperlessV2;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getQueueInfoByParams(array $params)
 * @method clearOrderByParams(array $params)
 * @method debugByParams(array $params)
 * @method whyByParams(array $params)
 * @method getProductsInOrderByParams(array $params)
 * @method pingWebsocketByParams(array $params)
 * @method addProcessesByParams(array $params)
 * @method takeOrderDetailByParams(array $params)
 * @method refreshStaffStateByParams(array $params)
 * @method saveProcessHzsByParams(array $params)
 * @method testFuncByParams(array $params)
 * @method sendXiuNotifyByParams(array $params)
 * @method fixHangOrderByParams(array $params)
 */
class Debug {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getQueueInfo
     *
     * @param  string $storeId storeId [ require true ]
     * @param  bool $refresh refresh [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQueueInfo (string $storeId, bool $refresh = false) {
        return self::getClass()->getQueueInfo([
            "storeId" => $storeId,
            "refresh" => $refresh,
        ]);
    }

    /**
     * 恢复到等待拍摄状态
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearOrder () {
        return self::getClass()->clearOrder();
    }

    /**
     * debug
     *
     * @support  string $orderNo orderNo require false
     * @support  string $orderId orderId require false
     * @support  string $staffId orderId require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function debug () {
        return self::getClass()->debug();
    }

    /**
     * why
     *
     * @param  int $storeId storeId [ require true ]
     * @param  int $staffId staffId [ require true ]
     * @param  string $staffType staffType [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function why (int $storeId, int $staffId, string $staffType) {
        return self::getClass()->why([
            "storeId" => $storeId,
            "staffId" => $staffId,
            "staffType" => $staffType,
        ]);
    }

    /**
     * getProductsInOrder
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsInOrder (int $id) {
        return self::getClass()->getProductsInOrder([
            "id" => $id,
        ]);
    }

    /**
     * ping websocket
     *
     * @support  int $storeId 门店id require false
     * @support  int $staffId 伙伴id require false
     * @support  string $staffType 摄影师: sys,化妆师: hzs require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function pingWebsocket () {
        return self::getClass()->pingWebsocket();
    }

    /**
     * addProcesses
     *
     * @param  int $orderId orderId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProcesses (int $orderId) {
        return self::getClass()->addProcesses([
            "orderId" => $orderId,
        ]);
    }

    /**
     * takeOrderDetail
     *
     * @param  string $key key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeOrderDetail (string $key) {
        return self::getClass()->takeOrderDetail([
            "key" => $key,
        ]);
    }

    /**
     * 伙伴状态恢复到等待
     *
     * @support  int $storeId 门店id require false
     * @support  int $staffId 伙伴id require false
     * @support  string $staffType 伙伴类型 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshStaffState () {
        return self::getClass()->refreshStaffState();
    }

    /**
     * saveProcessHzs
     *
     * @support  string $token token [ require true ]
     * @support  int $orderId orderId [ require true ]
     * @support  int $staffId staffId [ require true ]
     * @support  int $processId processId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveProcessHzs () {
        return self::getClass()->saveProcessHzs();
    }

    /**
     * testFunc
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function testFunc () {
        return self::getClass()->testFunc();
    }

    /**
     * 摄影师底片推送
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendXiuNotify () {
        return self::getClass()->sendXiuNotify();
    }

    /**
     * fixHangOrder
     *
     * @support  string $orderIds 订单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixHangOrder () {
        return self::getClass()->fixHangOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperlessV2', 'Debug');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperlessV2', 'Debug');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}