<?php
namespace Mainto\Bridge\Invokes\ProjectPaperlessV2;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method delaySendNoticeBySelectPhotoTimeout15MinuteByParams(array $params)
 * @method delaySendNoticeBySelectPhotoTimeout30MinuteByParams(array $params)
 * @method changeSalesByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method refundOrderByParams(array $params)
 * @method partRefundOrderByParams(array $params)
 * @method syncPassProductIdsByParams(array $params)
 * @method hookPictureOrderChangeToStoreByParams(array $params)
 * @method hookPictureOrderTagDissatisfiedByParams(array $params)
 * @method orderRetakeSaleSkuByParams(array $params)
 * @method retakeOrderCancelNotifyByParams(array $params)
 */
class MessageHook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 选片超时15分钟通知
     *
     * @support  int $processId 流程Id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function delaySendNoticeBySelectPhotoTimeout15Minute () {
        return self::getClass()->delaySendNoticeBySelectPhotoTimeout15Minute();
    }

    /**
     * 选片超时30分钟通知
     *
     * @support  int $process_id 流程Id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function delaySendNoticeBySelectPhotoTimeout30Minute () {
        return self::getClass()->delaySendNoticeBySelectPhotoTimeout30Minute();
    }

    /**
     * 订单修改拍摄产品通知
     *
     * @support  int $orderId 订单Id require false
     * @support  int $storeId 门店Id require false
     * @support  array $removeSaleList 删除列表 require false
     * @support  array $createSaleList 创建列表 require false
     * @support  array $modifySaleList 修改列表 require false
     * @support  array $replaceSaleList 替换原产品列表 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeSales () {
        return self::getClass()->changeSales();
    }

    /**
     * 关闭订单流程
     *
     * @support  int $orderId 订单Id require false
     * @support  int $storeId 门店Id require false
     * @support  string $changeReserveTime 预约时间 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder () {
        return self::getClass()->closeOrder();
    }

    /**
     * 退回到等待拍摄流程
     *
     * @support  int $id 订单Id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function recoverWaitShooting () {
        return self::getClass()->recoverWaitShooting();
    }

    /**
     * 订单退款通知
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  int $storeId 门店Id [ require true ]
     * @support  array $closedSaleIds 退款sale_id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundOrder () {
        return self::getClass()->refundOrder();
    }

    /**
     * # TODO；待确定按 sale_id 退
     *
     * @support  int $orderId 订单Id [ require true ]
     * @support  int $storeId 门店Id [ require true ]
     * @support  array $orderSaleList 退款后SaleList require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function partRefundOrder () {
        return self::getClass()->partRefundOrder();
    }

    /**
     * 更新通关产品ids
     *
     * @support  int $staffId 伙伴id require false
     * @support  array $productIds 通关产品ids require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncPassProductIds () {
        return self::getClass()->syncPassProductIds();
    }

    /**
     * hookPictureOrderChangeToStore
     *
     * @support  uint $retoucher_no 修片师 [ require true ]
     * @support  string $customer_name 顾客名 [ require true ]
     * @support  string $order_no 订单号 [ require true ]
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPictureOrderChangeToStore () {
        return self::getClass()->hookPictureOrderChangeToStore();
    }

    /**
     * hookPictureOrderTagDissatisfied
     *
     * @support  uint $retoucher_no 修片师 [ require true ]
     * @support  string $customer_name 顾客名 [ require true ]
     * @support  string $order_no 订单号 [ require true ]
     * @support  string $serial_no 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPictureOrderTagDissatisfied () {
        return self::getClass()->hookPictureOrderTagDissatisfied();
    }

    /**
     * orderRetakeSaleSku
     *
     * @support  uint $orderId 订单id [ require true ]
     * @support  uint $storeId 门店id [ require true ]
     * @support  uint $retakeNewStoreId 重拍之后新门店id require false
     * @support  uint $retakeNewOrderId 重拍之后新建的订单id require false
     * @support  array $retakeOrderSakeSku 重拍的拍摄产品 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderRetakeSaleSku () {
        return self::getClass()->orderRetakeSaleSku();
    }

    /**
     * 重拍订单超时关闭通知
     *
     * @support  uint $afterOrderId 重拍后新建订单的订单Id [ require true ]
     * @support  uint $afterStoreId 重拍后新建订单的门店Id [ require true ]
     * @support  string $cancelType 取消类型，auto：系统操作(超时)，hand：手动操作 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function retakeOrderCancelNotify () {
        return self::getClass()->retakeOrderCancelNotify();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperlessV2', 'MessageHook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperlessV2', 'MessageHook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}