<?php
namespace Mainto\Bridge\Invokes\ProjectPaperlessV2\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchByParams(array $params)
 * @method uploadListByParams(array $params)
 */
class UploadRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 摄影师中心：搜索订单
     *
     * @support  string $orderNo 订单号 require false
     * @support  string $userName 顾客姓名 require false
     * @support  string $userPhone 顾客手机号 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function search () {
        return self::getClass()->search();
    }

    /**
     * 上传记录列表
     *
     * @support  string $type 查询类型 [ require true ]
     * @support  string $searchField 搜索字段 require false
     * @support  string $startTime 开始时间 require false
     * @support  string $endTime 结束时间 require false
     * @support  int $orderId 订单id require false
     * @support  bool $updatable 查询有更新的订单 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 页码 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function uploadList () {
        return self::getClass()->uploadList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperlessV2', 'Manage\UploadRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperlessV2', 'Manage\UploadRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}