<?php
namespace Mainto\Bridge\Invokes\ProjectPaperlessV2\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getWorkStatesByParams(array $params)
 * @method getAvailableStaffIdsByParams(array $params)
 * @method getCurrentHangStaffsByParams(array $params)
 * @method getHangTimeoutStaffsByParams(array $params)
 * @method getGroupsByParams(array $params)
 * @method getNamesByGroupIdsByParams(array $params)
 * @method storeStaffsByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴工作状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWorkStates () {
        return self::getClass()->getWorkStates();
    }

    /**
     * 获取伙伴工作状态
     *
     * @support  int $orderId 订单号 require false
     * @support  array $staffIds 伙伴id列表 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAvailableStaffIds () {
        return self::getClass()->getAvailableStaffIds();
    }

    /**
     * 获取当前挂起的用户列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCurrentHangStaffs () {
        return self::getClass()->getCurrentHangStaffs();
    }

    /**
     * 获取挂起超时的用户列表
     *
     * @support  int $time 挂起时间 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHangTimeoutStaffs () {
        return self::getClass()->getHangTimeoutStaffs();
    }

    /**
     * 获取门店分组列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroups () {
        return self::getClass()->getGroups();
    }

    /**
     * 通过groupIds获取分组名称列表
     *
     * @support  array $groupIds 分组id列表 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNamesByGroupIds () {
        return self::getClass()->getNamesByGroupIds();
    }

    /**
     * 根据伙伴类型获取成员列表
     *
     * @support  string $staffType 伙伴类型 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeStaffs () {
        return self::getClass()->storeStaffs();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperlessV2', 'Manage\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperlessV2', 'Manage\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}