<?php
namespace Mainto\Bridge\Invokes\ProjectPaperlessV2\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderOnlineListByParams(array $params)
 * @method searchOrderByParams(array $params)
 * @method pushOrderToCameramanByParams(array $params)
 * @method completeSelectPhotoByParams(array $params)
 * @method revokeCloudStreamByParams(array $params)
 * @method getCloudStreamInfoByParams(array $params)
 * @method submitToCloudExtraByParams(array $params)
 * @method allStreamSubmitByParams(array $params)
 * @method getHistoryInfoByParams(array $params)
 * @method getHistoryListByParams(array $params)
 * @method revokeOrderByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getUpyunSignByParams(array $params)
 * @method getUploadTokenByParams(array $params)
 * @method createCloudProductByParams(array $params)
 * @method enableCloudProductByParams(array $params)
 * @method batchGetStreamInfoByIdsByParams(array $params)
 * @method photoLimitByParams(array $params)
 * @method getTotalCountByParams(array $params)
 * @method getExtraHistoryListByParams(array $params)
 * @method revokeSubmitExtraByParams(array $params)
 * @method reSubmitExtraByParams(array $params)
 * @method getExtraPhotoDetailByParams(array $params)
 * @method remainingPhotoByParams(array $params)
 * @method shanghaiBlueStoreByParams(array $params)
 * @method getOrderTakeTimeByParams(array $params)
 * @method fixOldOrderByParams(array $params)
 */
class Cameraman {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 摄影师接单列表查询
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderOnlineList () {
        return self::getClass()->getOrderOnlineList();
    }

    /**
     * 拍摄订单查询
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $userName 顾客姓名 [ require true ]
     * @param  string $userPhone 手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchOrder (string $orderNum = '', string $userName = '', string $userPhone = '') {
        return self::getClass()->searchOrder([
            "orderNum" => $orderNum,
            "userName" => $userName,
            "userPhone" => $userPhone,
        ]);
    }

    /**
     * 订单添加至摄影师
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushOrderToCameraman (int $orderId) {
        return self::getClass()->pushOrderToCameraman([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 完成某个产品选片(原提交图片至云端)
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $processId 流程id [ require true ]
     * @support  int $saleSkuId sale sku id [ require true ]
     * @support  int $productId 产品id [ require true ]
     * @support  int $serviceId 服务id require false
     * @support  array $retouchClaim 修片要求 require false
     * @support  string $takeTime 取片时间 [ require true ]
     * @support  array $photoData 照片信息 [ require true ]
     * @support  string $photographyNote 摄影备注 require false
     * @support  string $dressNote 化妆备注 require false
     * @support  string $retouchNote 修片备注 [ require true ]
     * @support  string $colorNote 背景色备注 require false
     * @support  bool $reupload 是否重传 require false
     * @support  string $beforeStreamId 重传流水id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeSelectPhoto () {
        return self::getClass()->completeSelectPhoto();
    }

    /**
     * 撤回照片(流水维度)
     *
     * @param  int $cloudStreamId 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function revokeCloudStream (int $cloudStreamId) {
        return self::getClass()->revokeCloudStream([
            "cloudStreamId" => $cloudStreamId,
        ]);
    }

    /**
     * 云端流水详情
     *
     * @param  int $cloudStreamId 流水id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudStreamInfo (int $cloudStreamId) {
        return self::getClass()->getCloudStreamInfo([
            "cloudStreamId" => $cloudStreamId,
        ]);
    }

    /**
     * 多余底片上传
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $productId 产品id [ require true ]
     * @support  array $photos 照片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitToCloudExtra () {
        return self::getClass()->submitToCloudExtra();
    }

    /**
     * 全部流水确认上传
     *
     * @param  int $orderId 订单id [ require true ]
     * @support  bool $forceUpload 强制提交 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function allStreamSubmit (int $orderId) {
        return self::getClass()->allStreamSubmit([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取订单历史上传记录详情
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHistoryInfo (int $orderId) {
        return self::getClass()->getHistoryInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取摄影师历史上传记录列表
     *
     * @support  string $startTime 开始时间 require false
     * @support  string $endTime 结束时间 require false
     * @support  string $orderNum 订单号 require false
     * @support  string $userName 顾客姓名 require false
     * @support  string $userPhone 顾客手机号 require false
     * @support  bool $searchWithoutStaff 不根据伙伴查询 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHistoryList () {
        return self::getClass()->getHistoryList();
    }

    /**
     * 撤回照片(订单维度)
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function revokeOrder (int $orderId) {
        return self::getClass()->revokeOrder([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取Host
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 获取上传签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUploadToken () {
        return self::getClass()->getUploadToken();
    }

    /**
     * 创建云端产品
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createCloudProduct (int $productId) {
        return self::getClass()->createCloudProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 启用云端产品
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableCloudProduct (int $productId) {
        return self::getClass()->enableCloudProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 批量获取流水详情(通过流水id)
     *
     * @support  array $cloudStreamIds 流水ids require false
     * @support  string $brand 品牌 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchGetStreamInfoByIds () {
        return self::getClass()->batchGetStreamInfoByIds();
    }

    /**
     * 获取图片限制
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoLimit () {
        return self::getClass()->photoLimit();
    }

    /**
     * 获取赠送底片记录统计
     *
     * @support  string $startTime 开始时间 require false
     * @support  string $endTime 结束时间 require false
     * @support  string $orderNum 订单号 require false
     * @support  string $userName 顾客姓名 require false
     * @support  string $userPhone 顾客手机号 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTotalCount () {
        return self::getClass()->getTotalCount();
    }

    /**
     * 获取摄影师赠送底片上传记录列表
     *
     * @support  string $startTime 开始时间 require false
     * @support  string $endTime 结束时间 require false
     * @support  string $orderNum 订单号 require false
     * @support  string $userName 顾客姓名 require false
     * @support  string $userPhone 顾客手机号 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getExtraHistoryList () {
        return self::getClass()->getExtraHistoryList();
    }

    /**
     * 撤回赠送底片上传
     *
     * @support  int $id 赠送底片记录Id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function revokeSubmitExtra () {
        return self::getClass()->revokeSubmitExtra();
    }

    /**
     * 重新上传多余底片
     *
     * @support  int $id 历史记录id [ require true ]
     * @support  array $photos 照片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reSubmitExtra () {
        return self::getClass()->reSubmitExtra();
    }

    /**
     * 多余底片详情
     *
     * @support  int $id 历史记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getExtraPhotoDetail () {
        return self::getClass()->getExtraPhotoDetail();
    }

    /**
     * 获取剩余传输底片数量
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remainingPhoto () {
        return self::getClass()->remainingPhoto();
    }

    /**
     * 判断是否为上海蓝标店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function shanghaiBlueStore () {
        return self::getClass()->shanghaiBlueStore();
    }

    /**
     * 获取订单取片时间
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderTakeTime (int $orderId) {
        return self::getClass()->getOrderTakeTime([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 修复老订单至看片完成
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixOldOrder (int $orderId) {
        return self::getClass()->fixOldOrder([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperlessV2', 'Manage\Cameraman');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperlessV2', 'Manage\Cameraman');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}