<?php
namespace Mainto\Bridge\Invokes\ProjectPaperlessV2\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRoomSignatureByParams(array $params)
 * @method enterRoomByParams(array $params)
 * @method readyWorkByParams(array $params)
 */
class WebSocket {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取ws签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRoomSignature () {
        return self::getClass()->getRoomSignature();
    }

    /**
     * 加入ws房间
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function enterRoom () {
        return self::getClass()->enterRoom();
    }

    /**
     * ws准备
     *
     * @support  string $ws_staff_type 连接ws伙伴类型 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function readyWork () {
        return self::getClass()->readyWork();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperlessV2', 'User\WebSocket');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperlessV2', 'User\WebSocket');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}