<?php
namespace Mainto\Bridge\Invokes\ProjectPaperlessV2;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queueToWaitingByParams(array $params)
 * @method refreshOrderSortByParams(array $params)
 * @method removeStaffHangByParams(array $params)
 * @method dailyCleanByParams(array $params)
 * @method dailyCleanLookingPhotoByParams(array $params)
 * @method refreshProductIdsByParams(array $params)
 * @method dingUsersWhenOrderHangingTimeOutByParams(array $params)
 * @method cronSendXiuNotifyByParams(array $params)
 * @method cronCheckAndRemoveUnReviewOrderByParams(array $params)
 * @method cronClearExpiredReservationByParams(array $params)
 * @method cronClearOrderUploadChangeSalesByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天9-23点每分钟执行-签到排队状态自动进入等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queueToWaiting () {
        return self::getClass()->queueToWaiting();
    }

    /**
     * 每天9-23点每10分钟执行
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshOrderSort () {
        return self::getClass()->refreshOrderSort();
    }

    /**
     * 每天9-23点每分钟执行-对超过1小时挂起的伙伴解除挂起
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStaffHang () {
        return self::getClass()->removeStaffHang();
    }

    /**
     * 每天4点执行-清空前一日流程记录
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function dailyClean () {
        return self::getClass()->dailyClean();
    }

    /**
     * 每天4点执行-看片中退回待看片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function dailyCleanLookingPhoto () {
        return self::getClass()->dailyCleanLookingPhoto();
    }

    /**
     * 每小时执行-重刷已上架产品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshProductIds () {
        return self::getClass()->refreshProductIds();
    }

    /**
     * 签到排队状态自动进入化妆等待队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function dingUsersWhenOrderHangingTimeOut () {
        return self::getClass()->dingUsersWhenOrderHangingTimeOut();
    }

    /**
     * cronSendXiuNotify
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronSendXiuNotify () {
        return self::getClass()->cronSendXiuNotify();
    }

    /**
     * (定时任务:)修改未审核完成的流水
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronCheckAndRemoveUnReviewOrder () {
        return self::getClass()->cronCheckAndRemoveUnReviewOrder();
    }

    /**
     * 定时清理过号
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronClearExpiredReservation () {
        return self::getClass()->cronClearExpiredReservation();
    }

    /**
     * 定时清理订单上传更新标记
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronClearOrderUploadChangeSales () {
        return self::getClass()->cronClearOrderUploadChangeSales();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperlessV2', 'Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperlessV2', 'Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}