<?php
namespace Mainto\Bridge\Invokes\ProjectPaperlessV2\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchByParams(array $params)
 * @method uploadListByParams(array $params)
 * @method tabRefundNotDealWithByParams(array $params)
 * @method tabOrderUpdateNotDealWithByParams(array $params)
 * @method variousUploadedTotalByParams(array $params)
 * @method uploadPhotoCloudByParams(array $params)
 */
class UploadRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 摄影师中心：搜索订单
     *
     * @support  string $orderNo 订单号 require false
     * @support  string $userName 顾客姓名 require false
     * @support  string $userPhone 顾客手机号 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function search () {
        return self::getClass()->search();
    }

    /**
     * 上传记录列表
     *
     * @support  string $type 查询类型 [ require true ]
     * @support  string $searchTimeField 搜索字段 require false
     * @support  string $startTime 开始时间 require false
     * @support  string $endTime 结束时间 require false
     * @support  string $sortField 排序字段 require false
     * @support  string $sort 排序方式 require false
     * @support  int $orderId 订单id require false
     * @support  bool $updatable 查询有更新的订单 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 页码 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function uploadList () {
        return self::getClass()->uploadList();
    }

    /**
     * 标记退款中不需要处理
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $saleId 销售id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function tabRefundNotDealWith () {
        return self::getClass()->tabRefundNotDealWith();
    }

    /**
     * 标记订单无需处理
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function tabOrderUpdateNotDealWith () {
        return self::getClass()->tabOrderUpdateNotDealWith();
    }

    /**
     * 获取各上传总数
     *
     * @support  bool $updatable 查询有更新的订单 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function variousUploadedTotal () {
        return self::getClass()->variousUploadedTotal();
    }

    /**
     * 上传照片到云端
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $processId 流程id [ require true ]
     * @support  int $productId 产品id [ require true ]
     * @support  int $serviceId 服务id require false
     * @support  array $retouchClaim 修片要求 require false
     * @support  string $takeTime 取片时间 [ require true ]
     * @support  array $photoData 照片信息 [ require true ]
     * @support  string $photographyNote 摄影备注 require false
     * @support  string $dressNote 化妆备注 require false
     * @support  string $retouchNote 修片备注 [ require true ]
     * @support  string $colorNote 背景色备注 require false
     * @support  bool $reupload 是否重传 require false
     * @support  int $beforeStreamId 重传流水id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function uploadPhotoCloud () {
        return self::getClass()->uploadPhotoCloud();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperlessV2', 'Manage\UploadRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperlessV2', 'Manage\UploadRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}