<?php
namespace Mainto\Bridge\Invokes\ProjectPaperlessV2\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method assignSecondRetouchByParams(array $params)
 * @method changeSecondRetouchStoreByParams(array $params)
 * @method cancelChangeSecondRetouchStoreByParams(array $params)
 * @method getSecondRetouchChangeStoreOrderListByParams(array $params)
 * @method deleteByParams(array $params)
 * @method saveByParams(array $params)
 * @method findOneByOrderNumByParams(array $params)
 */
class ChangeStoreWatchPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 转门店看片指派【看片】
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  uint $staffId 工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function assignSecondRetouch (string $orderNum, int $staffId) {
        return self::getClass()->assignSecondRetouch([
            "orderNum" => $orderNum,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 转门店操作
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  uint $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeSecondRetouchStore (string $orderNum, int $storeId = 0) {
        return self::getClass()->changeSecondRetouchStore([
            "orderNum" => $orderNum,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 取消转门店操作
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  uint $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelChangeSecondRetouchStore (string $orderNum, int $storeId = 0) {
        return self::getClass()->cancelChangeSecondRetouchStore([
            "orderNum" => $orderNum,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取转门店订单列表
     *
     * @support  string $orderNum 订单号 require false
     * @support  string $userName 姓名 require false
     * @support  string $userPhone 手机号 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSecondRetouchChangeStoreOrderList () {
        return self::getClass()->getSecondRetouchChangeStoreOrderList();
    }

    /**
     * 删除看片转门店信息
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  uint $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $storeId, string $orderNum) {
        return self::getClass()->delete([
            "storeId" => $storeId,
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 保存看片转门店信息
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  uint $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function save (int $storeId, string $orderNum) {
        return self::getClass()->save([
            "storeId" => $storeId,
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 获取看片转门店信息
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function findOneByOrderNum (string $orderNum) {
        return self::getClass()->findOneByOrderNum([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperlessV2', 'Manage\ChangeStoreWatchPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperlessV2', 'Manage\ChangeStoreWatchPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}