<?php
namespace Mainto\Bridge\Invokes\ProjectPaperlessV2\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductsByParams(array $params)
 * @method getProductDetailByParams(array $params)
 * @method checkWebsocketAliveByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店所有产品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProducts () {
        return self::getClass()->getProducts();
    }

    /**
     * 门店产品详情
     *
     * @support  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDetail () {
        return self::getClass()->getProductDetail();
    }

    /**
     * 检查websocket连接是否正常
     *
     * @support  string $uuid UUID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkWebsocketAlive () {
        return self::getClass()->checkWebsocketAlive();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectPaperlessV2', 'User\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectPaperlessV2', 'User\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}