<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-03-29 16:15:56
 */
namespace Mainto\Bridge\Structs\ProjectMainto\Cmd\User;

class UserGuestH5InformationCmd {
    /**
     * @var  string
     * 用户称呼
     * validation: min:1|max:20
     */
    public string $nickName;
    /**
     * @var  array
     * 风格Ids
     * validation: 
     */
    public array $styleProductIds = [];
    /**
     * @var  string
     * 客户预约时间段
     * validation: in:three_month,six_month,one_year,future_year
     */
    public string $reserveTime;
    /**
     * @var  int
     * 用户手机号
     * validation: sometimes|min:11|max:11
     */
    public int $phone;
    /**
     * @var  string
     * 用户微信号
     * validation: 
     */
    public string $wechat;
    /**
     * @var  int
     * 城市Id
     * validation: 
     */
    public int $cityId;
    /**
     * @var  string
     * 拍摄类型
     * validation: in:xiezhen,mantu,mantu_guofeng
     */
    public string $photographyType;
    /**
     * @var  string
     * 客资类型
     * validation: in:appointment_consult,appointment_polite,himo_guest
     */
    public string $guestType = "appointment_polite";
    /**
     * @var  string
     * 用户备注
     * validation: max:300
     */
    public string $note;

    public function __construct (string $nickName = '', string $reserveTime = '', int $phone = 0, string $wechat = '', int $cityId = 0, string $photographyType = '', string $note = '') {
        if (!is_null($nickName)) {
            $this->nickName = $nickName;
        }
        if (!is_null($reserveTime)) {
            $this->reserveTime = $reserveTime;
        }
        if (!is_null($phone)) {
            $this->phone = $phone;
        }
        if (!is_null($wechat)) {
            $this->wechat = $wechat;
        }
        if (!is_null($cityId)) {
            $this->cityId = $cityId;
        }
        if (!is_null($photographyType)) {
            $this->photographyType = $photographyType;
        }
        if (!is_null($note)) {
            $this->note = $note;
        }
    }

    public static function create(string $nickName = '', string $reserveTime = '', int $phone = 0, string $wechat = '', int $cityId = 0, string $photographyType = '', string $note = ''): self {
        return new self($nickName, $reserveTime, $phone, $wechat, $cityId, $photographyType, $note);
    }

    public function setNickName(string $nickName): self {
        $this->nickName = $nickName;

        return $this;
    }

    public function setStyleProductIds(array $styleProductIds): self {
        $this->styleProductIds = $styleProductIds;

        return $this;
    }

    public function setReserveTime(string $reserveTime): self {
        $this->reserveTime = $reserveTime;

        return $this;
    }

    public function setPhone(int $phone): self {
        $this->phone = $phone;

        return $this;
    }

    public function setWechat(string $wechat): self {
        $this->wechat = $wechat;

        return $this;
    }

    public function setCityId(int $cityId): self {
        $this->cityId = $cityId;

        return $this;
    }

    public function setPhotographyType(string $photographyType): self {
        $this->photographyType = $photographyType;

        return $this;
    }

    public function setGuestType(string $guestType): self {
        $this->guestType = $guestType;

        return $this;
    }

    public function setNote(string $note): self {
        $this->note = $note;

        return $this;
    }
}